/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.os.SystemClock;
import android.util.Log;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;

public class SntpClient {
    private static final String TAG = "SntpClient";
    private static final boolean DBG = true;
    private static final int REFERENCE_TIME_OFFSET = 16;
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_PORT = 123;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_MODE_SERVER = 4;
    private static final int NTP_MODE_BROADCAST = 5;
    private static final int NTP_VERSION = 3;
    private static final int NTP_LEAP_NOSYNC = 3;
    private static final int NTP_STRATUM_DEATH = 0;
    private static final int NTP_STRATUM_MAX = 15;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    private long mNtpTime;
    private long mNtpTimeReference;
    private long mRoundTripTime;

    public boolean requestTime(String string, int n) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)("request time failed: " + exception));
            return false;
        }
        return this.requestTime(inetAddress, 123, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestTime(InetAddress inetAddress, int n, int n2) {
        try (DatagramSocket datagramSocket = null;){
            datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(n2);
            byte[] byArray = new byte[48];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
            byArray[0] = 27;
            long l = System.currentTimeMillis();
            long l2 = SystemClock.elapsedRealtime();
            this.writeTimeStamp(byArray, 40, l);
            datagramSocket.send(datagramPacket);
            DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
            datagramSocket.receive(datagramPacket2);
            long l3 = SystemClock.elapsedRealtime();
            long l4 = l + (l3 - l2);
            byte by = (byte)(byArray[0] >> 6 & 3);
            byte by2 = (byte)(byArray[0] & 7);
            int n3 = byArray[1] & 0xFF;
            long l5 = this.readTimeStamp(byArray, 24);
            long l6 = this.readTimeStamp(byArray, 32);
            long l7 = this.readTimeStamp(byArray, 40);
            SntpClient.checkValidServerReply(by, by2, n3, l7);
            long l8 = l3 - l2 - (l7 - l6);
            long l9 = (l6 - l5 + (l7 - l4)) / 2L;
            Log.d((String)TAG, (String)("round trip: " + l8 + "ms, " + "clock offset: " + l9 + "ms"));
            this.mNtpTime = l4 + l9;
            this.mNtpTimeReference = l3;
            this.mRoundTripTime = l8;
        }
        return true;
    }

    public long getNtpTime() {
        return this.mNtpTime;
    }

    public long getNtpTimeReference() {
        return this.mNtpTimeReference;
    }

    public long getRoundTripTime() {
        return this.mRoundTripTime;
    }

    private static void checkValidServerReply(byte by, byte by2, int n, long l) {
        if (by == 3) {
            throw new InvalidServerReplyException("unsynchronized server");
        }
        if (by2 != 4 && by2 != 5) {
            throw new InvalidServerReplyException("untrusted mode: " + by2);
        }
        if (n == 0 || n > 15) {
            throw new InvalidServerReplyException("untrusted stratum: " + n);
        }
        if (l == 0L) {
            throw new InvalidServerReplyException("zero transmitTime");
        }
    }

    private long read32(byte[] byArray, int n) {
        int n2 = byArray[n];
        int n3 = byArray[n + 1];
        int n4 = byArray[n + 2];
        int n5 = byArray[n + 3];
        int n6 = (n2 & 0x80) == 128 ? (n2 & 0x7F) + 128 : n2;
        int n7 = (n3 & 0x80) == 128 ? (n3 & 0x7F) + 128 : n3;
        int n8 = (n4 & 0x80) == 128 ? (n4 & 0x7F) + 128 : n4;
        int n9 = (n5 & 0x80) == 128 ? (n5 & 0x7F) + 128 : n5;
        return ((long)n6 << 24) + ((long)n7 << 16) + ((long)n8 << 8) + (long)n9;
    }

    private long readTimeStamp(byte[] byArray, int n) {
        long l = this.read32(byArray, n);
        long l2 = this.read32(byArray, n + 4);
        if (l == 0L && l2 == 0L) {
            return 0L;
        }
        return (l - 2208988800L) * 1000L + l2 * 1000L / 0x100000000L;
    }

    private void writeTimeStamp(byte[] byArray, int n, long l) {
        if (l == 0L) {
            Arrays.fill(byArray, n, n + 8, (byte)0);
            return;
        }
        long l2 = l / 1000L;
        long l3 = l - l2 * 1000L;
        byArray[n++] = (byte)((l2 += 2208988800L) >> 24);
        byArray[n++] = (byte)(l2 >> 16);
        byArray[n++] = (byte)(l2 >> 8);
        byArray[n++] = (byte)(l2 >> 0);
        long l4 = l3 * 0x100000000L / 1000L;
        byArray[n++] = (byte)(l4 >> 24);
        byArray[n++] = (byte)(l4 >> 16);
        byArray[n++] = (byte)(l4 >> 8);
        byArray[n++] = (byte)(Math.random() * 255.0);
    }

    private static class InvalidServerReplyException
    extends Exception {
        public InvalidServerReplyException(String string) {
            super(string);
        }
    }
}

