/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.SystemClock;
import android.util.Log;
import com.immomo.baseutil.SntpClient;
import com.immomo.baseutil.TrustedTime;

public class NtpTrustedTime
implements TrustedTime {
    private static final String TAG = "NtpTrustedTime";
    private static final boolean LOGD = false;
    private static NtpTrustedTime sSingleton;
    private static Context sContext;
    private final long mTimeout;
    private ConnectivityManager mCM;
    private boolean mHasCache;
    private long mCachedNtpTime;
    private long mCachedNtpElapsedRealtime;
    private long mCachedNtpCertainty;
    private static String[] mNtpServers;

    private NtpTrustedTime(String string, long l) {
        this.mTimeout = l;
    }

    public static synchronized NtpTrustedTime getInstance(Context context) {
        if (sSingleton == null) {
            sSingleton = new NtpTrustedTime("2.android.pool.ntp.org", 2000L);
            sContext = context;
        }
        return sSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forceRefresh() {
        NtpTrustedTime ntpTrustedTime = this;
        synchronized (ntpTrustedTime) {
            if (this.mCM == null) {
                this.mCM = (ConnectivityManager)sContext.getSystemService("connectivity");
            }
        }
        Object object = ntpTrustedTime = this.mCM == null ? null : this.mCM.getActiveNetworkInfo();
        if (ntpTrustedTime == null || !ntpTrustedTime.isConnected()) {
            return false;
        }
        SntpClient sntpClient = new SntpClient();
        for (String string : mNtpServers) {
            long l = SystemClock.elapsedRealtime();
            boolean bl = sntpClient.requestTime(string, (int)this.mTimeout);
            Log.d((String)"zhangjj", (String)("" + bl + " " + string + " " + (SystemClock.elapsedRealtime() - l)));
            if (!bl) continue;
            this.mHasCache = true;
            this.mCachedNtpTime = sntpClient.getNtpTime();
            this.mCachedNtpElapsedRealtime = sntpClient.getNtpTimeReference();
            this.mCachedNtpCertainty = sntpClient.getRoundTripTime() / 2L;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCache() {
        return this.mHasCache;
    }

    @Override
    public long getCacheAge() {
        if (this.mHasCache) {
            return SystemClock.elapsedRealtime() - this.mCachedNtpElapsedRealtime;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long getCacheCertainty() {
        if (this.mHasCache) {
            return this.mCachedNtpCertainty;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long currentTimeMillis() {
        if (!this.mHasCache) {
            return -1L;
        }
        return this.mCachedNtpTime + this.getCacheAge();
    }

    public long getCachedNtpTime() {
        return this.mCachedNtpTime;
    }

    public long getCachedNtpTimeReference() {
        return this.mCachedNtpElapsedRealtime;
    }

    static {
        mNtpServers = new String[]{"ntp1.aliyun.com", "cn.ntp.org.cn", "1.android.pool.ntp.org", "ntp2.aliyun.com", "1.pool.ntp.org", "2.android.pool.ntp.org", "ntp3.aliyun.com", "ntp4.aliyun.com", "ntp5.aliyun.com", "ntp6.aliyun.com", "ntp7.aliyun.com", "edu.ntp.org.cn", "hk.ntp.org.cn", "tw.ntp.org.cn", "us.ntp.org.cn", "sgp.ntp.org.cn", "kr.ntp.org.cn", "jp.ntp.org.cn", "de.ntp.org.cn", "ina.ntp.org.cn", "sim.ntp.org.cn", "cn.pool.ntp.org", "hk.pool.ntp.org", "tw.ntp.org.cn", "asia.pool.ntp.org", "3.asia.pool.ntp.org", "0.centos.pool.ntp.org", "1.centos.pool.ntp.org", "time.asia.apple.com", "clock.cuhk.edu.hk", "133.100.11.8", "time.windows.com", "time.google.com"};
    }
}

