/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.content.Context;
import android.os.SystemClock;
import com.immomo.baseutil.NtpTrustedTime;
import com.immomo.baseutil.TrustedTime;

public class NetworkTimeUpdateService {
    private static final String TAG = "NetworkTimeService";
    private static final boolean DBG = false;
    private static final int EVENT_AUTO_TIME_CHANGED = 1;
    private static final long POLLING_INTERVAL_MS = 43200000L;
    private static final long NOT_SET = -1L;
    private Context mContext;
    private TrustedTime mTime;
    private long mLastNtpFetchTime = -1L;

    public NetworkTimeUpdateService(Context context) {
        this.mTime = NtpTrustedTime.getInstance(context);
        new Thread(new Runnable(){

            @Override
            public void run() {
                NetworkTimeUpdateService.this.onPollNetworkTime(1);
            }
        }, TAG).start();
    }

    private void onPollNetworkTime(int n) {
        long l = SystemClock.elapsedRealtime();
        long l2 = System.currentTimeMillis();
        if (this.mLastNtpFetchTime == -1L || l >= this.mLastNtpFetchTime + 43200000L || n == 1) {
            if (this.mTime.getCacheAge() >= 43200000L) {
                this.mTime.forceRefresh();
            }
            if (this.mTime.getCacheAge() < 43200000L) {
                this.mLastNtpFetchTime = SystemClock.elapsedRealtime();
            }
        }
    }

    public long currentTimeMillis() {
        return this.mTime != null ? this.mTime.currentTimeMillis() : -1L;
    }
}

