/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

public final class MemberStatistics {
    public long audioBitrate;
    public long videoBitrate;
    public long videoFramerate;
    public long receiveSize;
    public long vReceiveSize;
    public long aReceiveSize;
    public long srcUserid;
    public long videoWidth;
    public long videoHeight;
    public int audioDelay;
    public int audioLost;
    public int videoDelay;
    public int videoLost;
    public int audioPlayLag;
    public int pre_audioPlayLag;
    public int videoPlayLag;
    public long video_delayEx;
    public boolean audioMuted;
    public boolean videoMuted;
    private long pre_timestamp_ms;
    private long type;
    public static final int TOPR_MOMO = 256;
    public static final int TOPR_WEILA = 257;
    public static final int TOPR_AGORA = 258;
    public static final int TOPR_TXQQ = 259;
    public long pre_receiveSize;
    public long pre_vReceiveSize;
    public long pre_aReceiveSize;

    public MemberStatistics(long l) {
        this.init(l, 0L);
    }

    public MemberStatistics(long l, long l2) {
        this.init(l, l2);
    }

    private void init(long l, long l2) {
        this.reset();
        this.pre_timestamp_ms = System.currentTimeMillis();
        this.srcUserid = l;
        this.type = l2;
    }

    public void setType(long l) {
        this.type = l;
    }

    public long getId() {
        return this.srcUserid;
    }

    public void updateVideoStaticsByAgora(int n, int n2, int n3, int n4) {
        this.videoBitrate = n;
        this.videoFramerate = n2;
        this.videoWidth = n3;
        this.videoHeight = n4;
    }

    public void updateAudioQualityByAgora(int n, int n2) {
        this.audioDelay = n;
        this.audioLost = n2;
    }

    public void onUserMuteVideo(boolean bl) {
        this.videoMuted = bl;
    }

    public void onUserMuteAudio(boolean bl) {
        this.audioMuted = bl;
    }

    private void reset() {
        this.audioBitrate = 0L;
        this.videoBitrate = 0L;
        this.videoFramerate = 0L;
        this.receiveSize = 0L;
        this.vReceiveSize = 0L;
        this.aReceiveSize = 0L;
        this.srcUserid = 0L;
        this.videoWidth = 0L;
        this.videoHeight = 0L;
        this.videoMuted = false;
        this.audioMuted = false;
        this.audioDelay = 0;
        this.audioLost = 0;
        this.pre_audioPlayLag = 0;
    }

    public String getInfo() {
        return this.getInfoV3();
    }

    public String getInfoV3() {
        long l;
        long l2 = this.receiveSize - this.pre_receiveSize;
        long l3 = this.vReceiveSize - this.pre_vReceiveSize;
        long l4 = this.aReceiveSize - this.pre_aReceiveSize;
        long l5 = this.audioPlayLag - this.pre_audioPlayLag;
        if (257L == this.type && (l = System.currentTimeMillis() - this.pre_timestamp_ms) > 0L) {
            if (l4 > 0L) {
                this.audioBitrate = l4 / l * 8L;
            }
            if (l3 > 0L) {
                this.videoBitrate = l3 / l * 8L;
            }
            this.pre_timestamp_ms = System.currentTimeMillis();
        }
        String string = this.makeLogItem(this.audioBitrate, this.videoBitrate, this.videoFramerate, l2 > 0L ? l2 : 0L, l3 > 0L ? l3 : 0L, l4 > 0L ? l4 : 0L, this.srcUserid, this.videoMuted ? 0L : this.videoWidth, this.videoMuted ? 0L : this.videoHeight, this.audioDelay, this.audioLost, this.videoDelay, this.videoLost, l5 > 0L ? l5 : 0L, this.videoPlayLag, this.video_delayEx, this.audioMuted ? 1 : 0, this.videoMuted ? 1 : 0);
        this.videoWidth = 0L;
        this.videoHeight = 0L;
        this.pre_receiveSize = this.receiveSize;
        this.pre_vReceiveSize = this.vReceiveSize;
        this.pre_aReceiveSize = this.aReceiveSize;
        this.pre_audioPlayLag = this.audioPlayLag;
        return string;
    }

    private String makeLogItem(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        if (null != objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(objectArray[i]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

