/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Process;
import com.immomo.baseutil.DebugLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public final class MemAndCpuStatistics
implements Handler.Callback {
    private static volatile MemAndCpuStatistics instance = null;
    private ActivityManager activityManager;
    private Long lastCpuTime;
    private Long lastAppCpuTime;
    private RandomAccessFile procStatFile;
    private RandomAccessFile appStatFile;
    private HandlerThread handlerThread = new HandlerThread("MemAndCpuStatistics");
    private Handler handler;
    private static final int GET_NEW_CPU_MEM_INFO = 256;
    private double mCpu = 0.0;
    private double mMem = 0.0;
    private volatile boolean mInitFlag = false;

    private MemAndCpuStatistics() {
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper(), (Handler.Callback)this);
        DebugLog.d("jzheng", " get new MemAndCpuStatistics " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MemAndCpuStatistics getInstance() {
        if (instance != null) return instance;
        Class<MemAndCpuStatistics> clazz = MemAndCpuStatistics.class;
        synchronized (MemAndCpuStatistics.class) {
            if (instance != null) return instance;
            instance = new MemAndCpuStatistics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int getCpu() {
        return (int)this.mCpu;
    }

    public int getMem() {
        return (int)this.mMem;
    }

    public String getCPUandMemStatistics() {
        int n = (int)this.mCpu;
        if (n > 100 || n < 0) {
            n = 0;
        }
        int n2 = (int)this.mMem;
        return String.valueOf("" + n + "," + n2);
    }

    public void init(Context context) {
        this.activityManager = (ActivityManager)context.getSystemService("activity");
    }

    public void start() {
        this.mInitFlag = true;
        this.handler.sendEmptyMessage(256);
    }

    public void stop() {
        this.mInitFlag = false;
    }

    private double sampleCPU() {
        double d = 0.0;
        try {
            if (this.procStatFile == null || this.appStatFile == null) {
                this.procStatFile = new RandomAccessFile("/proc/stat", "r");
                this.appStatFile = new RandomAccessFile("/proc/" + Process.myPid() + "/stat", "r");
            } else {
                this.procStatFile.seek(0L);
                this.appStatFile.seek(0L);
            }
            String string = this.procStatFile.readLine();
            String string2 = this.appStatFile.readLine();
            String[] stringArray = string.split(" ");
            String[] stringArray2 = string2.split(" ");
            long l = Long.parseLong(stringArray[2]) + Long.parseLong(stringArray[3]) + Long.parseLong(stringArray[4]) + Long.parseLong(stringArray[5]) + Long.parseLong(stringArray[6]) + Long.parseLong(stringArray[7]) + Long.parseLong(stringArray[8]);
            long l2 = Long.parseLong(stringArray2[13]) + Long.parseLong(stringArray2[14]);
            if (this.lastCpuTime == null && this.lastAppCpuTime == null) {
                this.lastCpuTime = l;
                this.lastAppCpuTime = l2;
                return d;
            }
            d = (double)(l2 - this.lastAppCpuTime) / (double)(l - this.lastCpuTime) * 100.0;
            if ((int)d >= 100) {
                d = 0.0;
            }
            this.lastCpuTime = l;
            this.lastAppCpuTime = l2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            d = 0.0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return Math.abs(d);
    }

    private List<String> getThreadInfoList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            File file = new File("/proc/" + Process.myPid() + "/task/");
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                int n = 0;
                for (int i = 0; i < fileArray.length; ++i) {
                    String string = fileArray[i].getName();
                    if (string.equals(".") || string.equals("..") || !fileArray[i].isDirectory()) continue;
                    String string2 = fileArray[i].getAbsolutePath();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string2 + "/stat", "r");
                    arrayList.add(randomAccessFile.readLine());
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private double sampleMemory() {
        double d = 0.0;
        try {
            int n;
            Debug.MemoryInfo[] memoryInfoArray;
            if (this.activityManager != null && (memoryInfoArray = this.activityManager.getProcessMemoryInfo(new int[]{Process.myPid()})).length > 0 && (n = memoryInfoArray[0].getTotalPss()) >= 0) {
                d = (double)n / 1024.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 256: {
                this.handler.removeMessages(256);
                if (this.mInitFlag) {
                    this.mCpu = Math.abs(this.sampleCPU());
                    this.mMem = Math.abs(this.sampleMemory());
                }
                this.handler.sendEmptyMessageDelayed(256, 10000L);
                break;
            }
        }
        return false;
    }
}

