/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.os.SystemClock;
import com.immomo.baseutil.DebugLog;

public class MediaStatisticModel {
    private float faceLighting;
    private float faceSmooth;
    private float bigEye;
    private float thinFace;
    private int useDoki;
    private volatile boolean haveFaces;
    private int signalStrength;
    private String wifiOrOther = "wifi";
    private FeaturesCost faceDetectCost = new FeaturesCost("faceDetectCost");
    private FeaturesCost adjustFilterCost = new FeaturesCost("adjustFilterCost");
    private FeaturesCost bodyDetect = new FeaturesCost("bodyDetect");
    private FeaturesCost expressDetect = new FeaturesCost("expressDetect");
    private FeaturesCost gestureDetect = new FeaturesCost("gestureDetect");
    private FeaturesCost imageSegCost = new FeaturesCost("imageSegCost");
    private FeaturesCost cpuProcessCost = new FeaturesCost("cpuProcessCost");

    public boolean getHaveFaces() {
        return this.haveFaces;
    }

    public void setHaveFaces(boolean bl) {
        this.haveFaces = bl;
    }

    public String getWifiOrOther() {
        return this.wifiOrOther;
    }

    public void setWifiOrOther(String string) {
        this.wifiOrOther = string;
    }

    public int getSignalStrength() {
        return this.signalStrength;
    }

    public void setSignalStrength(int n) {
        this.signalStrength = n;
    }

    public long getExpressDetect() {
        return this.expressDetect.getCost();
    }

    public void setExpressDetect(long l) {
        this.expressDetect.updateCost(l);
    }

    public long getBodyDetect() {
        return this.bodyDetect.getCost();
    }

    public void setBodyDetect(long l) {
        this.bodyDetect.updateCost(l);
    }

    public long getGestureDetect() {
        return this.gestureDetect.getCost();
    }

    public void setGestureDetect(long l) {
        this.gestureDetect.updateCost(l);
    }

    public long getImageDetect() {
        return this.imageSegCost.getCost();
    }

    public void setImageDetect(long l) {
        this.imageSegCost.updateCost(l);
    }

    public float getFaceLighting() {
        return this.faceLighting;
    }

    public void setFaceLighting(float f) {
        this.faceLighting = f;
    }

    public float getFaceSmooth() {
        return this.faceSmooth;
    }

    public void setFaceSmooth(float f) {
        this.faceSmooth = f;
    }

    public float getBigEye() {
        return this.bigEye;
    }

    public void setBigEye(float f) {
        this.bigEye = f;
    }

    public float getThinFace() {
        return this.thinFace;
    }

    public void setThinFace(float f) {
        this.thinFace = f;
    }

    public int getUseDoki() {
        return this.useDoki;
    }

    public void setUseDoki(int n) {
        this.useDoki = n;
    }

    public static MediaStatisticModel getInstance() {
        return Sigleton.sInstance;
    }

    private MediaStatisticModel() {
    }

    public long getFaceDetect() {
        return this.faceDetectCost.getCost();
    }

    public long getFaceDetectCount() {
        return this.faceDetectCost.getCount();
    }

    public void setFaceDetectCost(long l) {
        this.faceDetectCost.updateCost(l);
    }

    public void setFilterCost(long l) {
        this.adjustFilterCost.updateCost(l);
    }

    public long getFilterCost() {
        return this.adjustFilterCost.getCost();
    }

    public long getFilterCount() {
        return this.adjustFilterCost.getCount();
    }

    public void setCpuProcessCost(long l) {
        this.cpuProcessCost.updateCost(l);
    }

    public long getCpuProcessCost() {
        return this.cpuProcessCost.getCost();
    }

    public long getCpuProcessCount() {
        return this.cpuProcessCost.getCount();
    }

    public void resetFeatureTimeCost() {
        this.faceDetectCost.init();
        this.adjustFilterCost.init();
        this.bodyDetect.init();
        this.expressDetect.init();
        this.gestureDetect.init();
        this.imageSegCost.init();
        this.cpuProcessCost.init();
    }

    public void print() {
        this.faceDetectCost.print();
        this.adjustFilterCost.print();
        this.bodyDetect.print();
        this.expressDetect.print();
        this.gestureDetect.print();
        this.imageSegCost.print();
        this.cpuProcessCost.print();
        DebugLog.d("FeaturesCost", "===");
    }

    public class FeaturesCost {
        private String name;
        private long time;
        private long count;
        private long totalcost;
        private final Object lock = new Object();

        FeaturesCost(String string) {
            this.name = string;
            this.time = -1L;
            this.count = 0L;
            this.totalcost = 0L;
        }

        public void init() {
            this.time = SystemClock.elapsedRealtime();
            this.count = 0L;
            this.totalcost = 0L;
        }

        public long getCount() {
            return this.count;
        }

        public long getCost() {
            return this.totalcost;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCost(long l) {
            Object object = this.lock;
            synchronized (object) {
                if (this.time == -1L) {
                    this.time = SystemClock.elapsedRealtime();
                }
                this.totalcost += l;
                ++this.count;
            }
        }

        public void print() {
            long l = SystemClock.elapsedRealtime() - this.time;
            if (this.time == -1L) {
                l = 0L;
            }
            DebugLog.d("FeaturesCost", "[" + this.name + "]" + " (" + l + "," + this.count + "," + this.totalcost + ")");
        }
    }

    private static class Sigleton {
        private static MediaStatisticModel sInstance = new MediaStatisticModel();

        private Sigleton() {
        }
    }
}

