/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import com.immomo.baseutil.BatteryMetrics;
import com.immomo.baseutil.MediaLogsV2;
import com.immomo.baseutil.MediaStatisticModel;
import com.immomo.baseutil.MediaStatisticsPullV2;
import com.immomo.baseutil.MemAndCpuStatistics;
import com.immomo.baseutil.hw.EncoderDebugger;

public class MediaLogToolsV2 {
    private MediaLogToolsV2() {
    }

    public static String fillPullInitV2(MediaStatisticsPullV2 mediaStatisticsPullV2, MediaLogsV2.pullInitV2 pullInitV22) {
        if (mediaStatisticsPullV2 == null || pullInitV22 == null) {
            return null;
        }
        mediaStatisticsPullV2.timestamp = pullInitV22.timestamp = System.currentTimeMillis();
        pullInitV22.url = mediaStatisticsPullV2.url;
        mediaStatisticsPullV2.reset();
        return pullInitV22.toString();
    }

    public static String fillPullStartV2(MediaStatisticsPullV2 mediaStatisticsPullV2, MediaLogsV2.pullStartV2 pullStartV22) {
        if (mediaStatisticsPullV2 == null || pullStartV22 == null) {
            return null;
        }
        pullStartV22.timestamp = System.currentTimeMillis();
        pullStartV22.cdnip = mediaStatisticsPullV2.cdnip;
        pullStartV22.nettype = MediaStatisticModel.getInstance().getWifiOrOther();
        pullStartV22.metaTime = mediaStatisticsPullV2.metaTime;
        pullStartV22.connDuration = mediaStatisticsPullV2.connDuration;
        pullStartV22.vFirstReceiveDuration = mediaStatisticsPullV2.vFirstReceiveDuration;
        pullStartV22.aFirstReceiveDuration = mediaStatisticsPullV2.aFirstReceiveDuration;
        pullStartV22.vFirstDecodeDuration = mediaStatisticsPullV2.vFirstDecodeDuration;
        pullStartV22.aFirstDecodeDuration = mediaStatisticsPullV2.aFirstDecodeDuration;
        pullStartV22.vFirstRenderDuration = mediaStatisticsPullV2.vFirstRenderDuration;
        pullStartV22.aFirstRenderDuration = mediaStatisticsPullV2.aFirstRenderDuration;
        pullStartV22.streamCount = mediaStatisticsPullV2.streamCount;
        pullStartV22.url = mediaStatisticsPullV2.url;
        pullStartV22.isSupportHevcDecoder = EncoderDebugger.isCodecSupportedTypes(false, "video/hevc") ? 1L : 0L;
        pullStartV22.isHardwareDecoder = mediaStatisticsPullV2.isHardwareDecoder ? 1L : 0L;
        pullStartV22.priLocalIpAddr = BatteryMetrics.getInstance().getIpAddr();
        pullStartV22.videoFirstIDRHasMomoSei = mediaStatisticsPullV2.videoFirstIDRHasMomoSei;
        pullStartV22.ipAddrOfCDN = mediaStatisticsPullV2.ipAddrOfCDN;
        pullStartV22.ipAddrOfClient = mediaStatisticsPullV2.ipAddrOfClient;
        return pullStartV22.toString();
    }

    public static String fillPullStopV2(MediaStatisticsPullV2 mediaStatisticsPullV2, MediaLogsV2.pullStopV2 pullStopV22) {
        if (mediaStatisticsPullV2 == null || pullStopV22 == null) {
            return null;
        }
        pullStopV22.timestamp = System.currentTimeMillis();
        pullStopV22.errcode = mediaStatisticsPullV2.errcode;
        pullStopV22.playDuration = System.currentTimeMillis() - mediaStatisticsPullV2.timestamp;
        pullStopV22.cdnip = mediaStatisticsPullV2.cdnip;
        pullStopV22.url = mediaStatisticsPullV2.url;
        pullStopV22.dnsIp = mediaStatisticsPullV2.dnsIp;
        pullStopV22.nettype = MediaStatisticModel.getInstance().getWifiOrOther();
        pullStopV22.transferType = mediaStatisticsPullV2.transferType;
        mediaStatisticsPullV2.reset();
        return pullStopV22.toString();
    }

    public static String fillPullWatchV2(MediaStatisticsPullV2 mediaStatisticsPullV2, MediaLogsV2.pullWatchV2 pullWatchV22) {
        if (mediaStatisticsPullV2 == null || pullWatchV22 == null) {
            return null;
        }
        pullWatchV22.timestamp = System.currentTimeMillis();
        pullWatchV22.receiveSize = mediaStatisticsPullV2.receiveSize - mediaStatisticsPullV2.pre_receiveSize;
        pullWatchV22.vReceiveSize = mediaStatisticsPullV2.vReceiveSize - mediaStatisticsPullV2.pre_vReceiveSize;
        pullWatchV22.aReceiveSize = mediaStatisticsPullV2.aReceiveSize - mediaStatisticsPullV2.pre_aReceiveSize;
        mediaStatisticsPullV2.pre_receiveSize = mediaStatisticsPullV2.receiveSize;
        mediaStatisticsPullV2.pre_vReceiveSize = mediaStatisticsPullV2.vReceiveSize;
        mediaStatisticsPullV2.pre_aReceiveSize = mediaStatisticsPullV2.aReceiveSize;
        pullWatchV22.vCacheDuration = mediaStatisticsPullV2.vCacheDuration;
        pullWatchV22.aCacheDuration = mediaStatisticsPullV2.aCacheDuration;
        pullWatchV22.vDecodeCount = mediaStatisticsPullV2.vDecodeCount - mediaStatisticsPullV2.pre_vDecodeCount;
        pullWatchV22.aDecodeCount = mediaStatisticsPullV2.aDecodeCount - mediaStatisticsPullV2.pre_aDecodeCount;
        pullWatchV22.vRenderCount = mediaStatisticsPullV2.vRenderCount - mediaStatisticsPullV2.pre_vRenderCount;
        pullWatchV22.aRenderSize = mediaStatisticsPullV2.aRenderSize - mediaStatisticsPullV2.pre_aRenderSize;
        mediaStatisticsPullV2.pre_vDecodeCount = mediaStatisticsPullV2.vDecodeCount;
        mediaStatisticsPullV2.pre_aDecodeCount = mediaStatisticsPullV2.aDecodeCount;
        mediaStatisticsPullV2.pre_vRenderCount = mediaStatisticsPullV2.vRenderCount;
        mediaStatisticsPullV2.pre_aRenderSize = mediaStatisticsPullV2.aRenderSize;
        pullWatchV22.cpu = 0L;
        pullWatchV22.mem = 0L;
        pullWatchV22.videoFrameRate = 0L;
        pullWatchV22.audioBitrate = 0L;
        pullWatchV22.videoBitrate = 0L;
        pullWatchV22.playbackDelay = mediaStatisticsPullV2.playbackDelay;
        pullWatchV22.audioSampleRate = mediaStatisticsPullV2.audioSampleRate;
        pullWatchV22.mCpu = MemAndCpuStatistics.getInstance().getCpu();
        pullWatchV22.mMem = MemAndCpuStatistics.getInstance().getMem();
        pullWatchV22.batteryRemain = BatteryMetrics.getInstance().getBatteryRemin();
        pullWatchV22.batteryStatus = BatteryMetrics.getInstance().getBatteryStatus();
        pullWatchV22.videowidth = mediaStatisticsPullV2.videowidth;
        pullWatchV22.videoheight = mediaStatisticsPullV2.videoheight;
        pullWatchV22.businessType = mediaStatisticsPullV2.businessType;
        pullWatchV22.transferType = mediaStatisticsPullV2.transferType;
        pullWatchV22.physMem = 0L;
        pullWatchV22.signalStrength = MediaStatisticModel.getInstance().getSignalStrength();
        long l = mediaStatisticsPullV2.videoPackDontHasMomoSeiCount - mediaStatisticsPullV2.pre_videoPackDontHasMomoSeiCount;
        pullWatchV22.videoPackDontHasMomoSeiCount = l < 0L ? 0L : l;
        mediaStatisticsPullV2.pre_videoPackDontHasMomoSeiCount = mediaStatisticsPullV2.videoPackDontHasMomoSeiCount;
        return pullWatchV22.toString();
    }

    public static String fillBufferStartV2(MediaStatisticsPullV2 mediaStatisticsPullV2, MediaLogsV2.bufferStartV2 bufferStartV22) {
        if (mediaStatisticsPullV2 == null || bufferStartV22 == null) {
            return null;
        }
        bufferStartV22.timestamp = System.currentTimeMillis();
        bufferStartV22.videoCache = mediaStatisticsPullV2.vCacheDuration;
        bufferStartV22.audioCache = mediaStatisticsPullV2.aCacheDuration;
        bufferStartV22.transferType = mediaStatisticsPullV2.transferType;
        bufferStartV22.cdnip = mediaStatisticsPullV2.cdnip;
        bufferStartV22.nettype = MediaStatisticModel.getInstance().getWifiOrOther();
        bufferStartV22.signalStrength = MediaStatisticModel.getInstance().getSignalStrength();
        mediaStatisticsPullV2.bufferStartTimeing = bufferStartV22.timestamp;
        return bufferStartV22.toString();
    }

    public static String fillBufferStopV2(MediaStatisticsPullV2 mediaStatisticsPullV2, MediaLogsV2.bufferStopV2 bufferStopV22) {
        if (mediaStatisticsPullV2 == null || bufferStopV22 == null) {
            return null;
        }
        bufferStopV22.timestamp = System.currentTimeMillis();
        bufferStopV22.duration = bufferStopV22.timestamp - mediaStatisticsPullV2.bufferStartTimeing;
        bufferStopV22.videoCache = mediaStatisticsPullV2.vCacheDuration;
        bufferStopV22.audioCache = mediaStatisticsPullV2.aCacheDuration;
        bufferStopV22.transferType = mediaStatisticsPullV2.transferType;
        bufferStopV22.cdnip = mediaStatisticsPullV2.cdnip;
        bufferStopV22.nettype = MediaStatisticModel.getInstance().getWifiOrOther();
        bufferStopV22.signalStrength = MediaStatisticModel.getInstance().getSignalStrength();
        return bufferStopV22.toString();
    }

    public static String fillDropFrameStartV2(MediaStatisticsPullV2 mediaStatisticsPullV2, MediaLogsV2.dropFrameStartV2 dropFrameStartV22) {
        if (mediaStatisticsPullV2 == null || dropFrameStartV22 == null) {
            return null;
        }
        dropFrameStartV22.timestamp = System.currentTimeMillis();
        dropFrameStartV22.videoCache = mediaStatisticsPullV2.vCacheDuration;
        dropFrameStartV22.audioCache = mediaStatisticsPullV2.aCacheDuration;
        return dropFrameStartV22.toString();
    }

    public static String fillDropFrameStopV2(MediaStatisticsPullV2 mediaStatisticsPullV2, MediaLogsV2.dropFrameStopV2 dropFrameStopV22) {
        if (mediaStatisticsPullV2 == null || dropFrameStopV22 == null) {
            return null;
        }
        dropFrameStopV22.timestamp = System.currentTimeMillis();
        dropFrameStopV22.videoCache = mediaStatisticsPullV2.vCacheDuration;
        dropFrameStopV22.audioCache = mediaStatisticsPullV2.aCacheDuration;
        return dropFrameStopV22.toString();
    }
}

