/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.immomo.baseutil.DebugLog;
import com.immomo.baseutil.MediaLogToolsV2;
import com.immomo.baseutil.MediaLogsV2;
import com.immomo.baseutil.MediaStatisticsPullV2;
import com.immomo.baseutil.SimpleMediaLogsUpload;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class MediaLogPullV2
implements Handler.Callback {
    private static final String PULL_WATCH = "v2.pullWatch";
    private static final String PULL_INIT = "v2.pullInit";
    private static final String PULL_DETECT = "v2.pullDetect";
    private static final String PULL_START = "v2.pullStart";
    private static final String PULL_STOP = "v2.pullStop";
    private static final String BUFFER_START = "v2.bufferStart";
    private static final String BUFFER_STOP = "v2.bufferStop";
    private static final String DROP_FRAME_START = "v2.dropFrameStart";
    private static final String DROP_FRAME_STOP = "v2.dropFrameStop";
    private HandlerThread handlerThread;
    private Handler handler;
    private static final int prePareTimeout = 256;
    private static final int bufferingTimeout = 257;
    private static final int pullWatchCheck = 258;
    private static final int getDnsIP = 259;
    private static final int MSG_PULL_START = 512;
    private static final int MSG_PULL_STOP0 = 513;
    private static final int MSG_PULL_WATCH = 514;
    private static final int MSG_PULL_DETEC = 515;
    private onMessageFromMediaLogV2 mPostMsgToPlayer;
    private MediaStatisticsPullV2 mediaStatisticsPullV2;
    private SimpleMediaLogsUpload simpleMediaLogsUpload;
    private int mInterval = 5000;
    private int mCount = 30;
    private volatile boolean pullStopAlreadySend = false;
    private volatile boolean pullDetectAlreadySent = false;
    private final ArrayList<String> reportLogs = new ArrayList();
    private volatile boolean mUseNewLoguploadMethodFlag = false;

    private static String makeLogItem(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (null != objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(objectArray[i]);
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean isPullDetectAlreadySent() {
        return this.pullDetectAlreadySent;
    }

    public boolean isInited() {
        return this.mUseNewLoguploadMethodFlag;
    }

    public void pullInit() {
        DebugLog.pf("MediaLogPullV2", "");
        this.handlerThread = new HandlerThread("MediaLogPullV2");
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper(), (Handler.Callback)this);
        this.handler.sendEmptyMessage(259);
        this.handler.sendEmptyMessageDelayed(256, 10000L);
        this.handler.sendEmptyMessageDelayed(258, (long)this.mInterval);
        String string = MediaLogToolsV2.fillPullInitV2(this.mediaStatisticsPullV2, new MediaLogsV2.pullInitV2());
        this.uploadLogs(PULL_INIT, string);
    }

    public void mediaLogs(String string, String string2) {
        String string3 = MediaLogPullV2.makeLogItem(System.currentTimeMillis(), string, string2);
        this.uploadLogs("v2.mediaLogs", string3);
    }

    public void pullDetect() {
        if (!this.pullDetectAlreadySent) {
            this.pullDetectAlreadySent = true;
            if (this.mediaStatisticsPullV2 != null && this.mediaStatisticsPullV2.pullDetect != null) {
                this.uploadLogs(PULL_DETECT, this.mediaStatisticsPullV2.pullDetect);
            }
        }
    }

    public void pullStart() {
        DebugLog.pf("MediaLogPullV2", "");
        if (this.handler != null && this.handlerThread != null) {
            this.handler.removeMessages(256);
        }
        this.pullDetect();
        String string = MediaLogToolsV2.fillPullStartV2(this.mediaStatisticsPullV2, new MediaLogsV2.pullStartV2());
        this.uploadLogs(PULL_START, string);
    }

    public void pullStop() {
        DebugLog.pf("MediaLogPullV2", "");
        if (!this.pullStopAlreadySend) {
            this.pullStopAlreadySend = true;
            if (this.handler != null && this.handlerThread != null) {
                this.handler.removeCallbacksAndMessages(null);
                this.handlerThread.quit();
                this.handler = null;
                this.handlerThread = null;
            }
            this.pullDetect();
            this.flushPullWatch(true);
            String string = MediaLogToolsV2.fillPullStopV2(this.mediaStatisticsPullV2, new MediaLogsV2.pullStopV2());
            this.uploadLogs(PULL_STOP, string);
            this.mPostMsgToPlayer = null;
            this.mediaStatisticsPullV2 = null;
            this.simpleMediaLogsUpload = null;
        }
    }

    public void pullWatch() {
        DebugLog.pf("MediaLogPullV2", "");
        if (this.handler != null && this.handlerThread != null) {
            this.handler.sendEmptyMessage(514);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWatch_l() {
        String string = MediaLogToolsV2.fillPullWatchV2(this.mediaStatisticsPullV2, new MediaLogsV2.pullWatchV2());
        ArrayList<String> arrayList = this.reportLogs;
        synchronized (arrayList) {
            this.reportLogs.add(string);
        }
        this.flushPullWatch(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPullWatch(boolean bl) {
        StringBuilder stringBuilder = null;
        ArrayList<String> arrayList = this.reportLogs;
        synchronized (arrayList) {
            if (this.reportLogs.size() >= this.mCount || bl) {
                stringBuilder = new StringBuilder();
                for (int i = 0; i < this.reportLogs.size(); ++i) {
                    stringBuilder.append(this.reportLogs.get(i));
                }
                this.reportLogs.clear();
            }
        }
        if (stringBuilder != null && stringBuilder.length() > 0) {
            this.uploadLogs(PULL_WATCH, stringBuilder.toString());
        }
    }

    public void bufferStart() {
        DebugLog.pf("MediaLogPullV2", "");
        if (this.handler != null && this.handlerThread != null) {
            this.handler.sendEmptyMessageDelayed(257, 20000L);
        }
        String string = MediaLogToolsV2.fillBufferStartV2(this.mediaStatisticsPullV2, new MediaLogsV2.bufferStartV2());
        this.uploadLogs(BUFFER_START, string);
    }

    public void bufferStop() {
        DebugLog.pf("MediaLogPullV2", "");
        if (this.handler != null && this.handlerThread != null) {
            this.handler.removeMessages(257);
        }
        String string = MediaLogToolsV2.fillBufferStopV2(this.mediaStatisticsPullV2, new MediaLogsV2.bufferStopV2());
        this.uploadLogs(BUFFER_STOP, string);
    }

    public void dropFrameStart() {
        DebugLog.pf("MediaLogPullV2", "");
        String string = MediaLogToolsV2.fillDropFrameStartV2(this.mediaStatisticsPullV2, new MediaLogsV2.dropFrameStartV2());
        this.uploadLogs(DROP_FRAME_START, string);
    }

    public void dropFrameStop() {
        DebugLog.pf("MediaLogPullV2", "");
        String string = MediaLogToolsV2.fillDropFrameStopV2(this.mediaStatisticsPullV2, new MediaLogsV2.dropFrameStopV2());
        this.uploadLogs(DROP_FRAME_STOP, string);
    }

    public final void setSimpleMediaLogsUpload(int n, int n2, SimpleMediaLogsUpload simpleMediaLogsUpload) {
        DebugLog.pf("MediaLogPullV2", "");
        this.mUseNewLoguploadMethodFlag = true;
        this.simpleMediaLogsUpload = simpleMediaLogsUpload;
        this.mInterval = n;
        this.mCount = n2;
    }

    private void uploadLogs(String string, String string2) {
        if (string != null && string2 != null && this.simpleMediaLogsUpload != null) {
            this.simpleMediaLogsUpload.upload3("nonconf", string, string2);
        }
    }

    public void setMediaStatisticsPullV2(MediaStatisticsPullV2 mediaStatisticsPullV2) {
        DebugLog.pf("MediaLogPullV2", "");
        this.mediaStatisticsPullV2 = mediaStatisticsPullV2;
    }

    public void setPostMsgToPlayer(onMessageFromMediaLogV2 onMessageFromMediaLogV22) {
        DebugLog.pf("MediaLogPullV2", "");
        this.mPostMsgToPlayer = onMessageFromMediaLogV22;
    }

    private void sendMessage(int n, int n2, int n3, Object object) {
        if (this.mPostMsgToPlayer != null) {
            this.mPostMsgToPlayer.messageFromMediaLogV2(n, n2, n3, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocalDNS() {
        Process process = null;
        BufferedReader bufferedReader = null;
        String string = "";
        try {
            process = Runtime.getRuntime().exec("getprop net.dns1");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = string = bufferedReader.readLine();
            return string2;
        }
        catch (IOException iOException) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            process.destroy();
        }
    }

    public boolean handleMessage(Message message) {
        int n = 100;
        int n2 = 200;
        int n3 = 1000;
        switch (message.what) {
            case 256: {
                this.sendMessage(100, 0, 1, null);
                break;
            }
            case 257: {
                this.sendMessage(100, 0, 6, null);
                break;
            }
            case 259: {
                if (this.mediaStatisticsPullV2 == null) break;
                this.mediaStatisticsPullV2.dnsIp = this.getLocalDNS();
                break;
            }
            case 258: {
                this.sendMessage(200, 1000, 0, null);
                if (this.handler == null || this.handlerThread == null) break;
                this.handler.sendEmptyMessageDelayed(258, (long)this.mInterval);
                break;
            }
            case 514: {
                this.pullWatch_l();
                break;
            }
        }
        return false;
    }

    public static interface onMessageFromMediaLogV2 {
        public void messageFromMediaLogV2(int var1, int var2, int var3, Object var4);
    }
}

