/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.support.annotation.NonNull;
import android.util.Log;
import com.immomo.baseutil.DebugLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaConfigsForIJK {
    private int use_new_whiten = -1;
    private int usm_enable = 0;
    private float usm_value_sharp = 0.7f;
    private float usm_value_saturation = 1.2f;
    private int faceSkip = 1;
    private int enable_audio_media_headset = 0;
    private int adapt_denoise_level = 0;
    private boolean enableWeilaVBR = true;
    private boolean enableVBRLimit = false;
    private int adapt_br_step = -1;
    private int adapt_br_min = -1;
    private int adapt_fr_min = -1;
    private String mQuicProxyConfig = null;
    private int quic_adapt_br_min = -1;
    private boolean enableV3LogReport = false;
    private int enable_audio_high_quality = 0;
    private List<AdaptSizeItem> mAdaptSizeList = new ArrayList<AdaptSizeItem>();
    private long mNtpUpdateTimeMs = 0L;
    private long ntpDeltMs = 0L;
    private long refreshTimeDeltMs = 3600000L;

    public static MediaConfigsForIJK getInstance() {
        return Sigleton.sInstance;
    }

    private MediaConfigsForIJK() {
    }

    public void updateConfigs(String string) {
        this.configDataProcess(string, 0);
    }

    private void configDataProcess(String string, int n) {
        JSONObject jSONObject = null;
        DebugLog.d("configdata", n + " configJson " + string);
        try {
            int n2;
            int n3;
            jSONObject = new JSONObject(string);
            if (jSONObject.has("enableVBR")) {
                n3 = jSONObject.getInt("enableVBR");
                DebugLog.d("configdata", n + " enableVBR " + n3);
                this.setEnableWeilaVBR(n3 == 1);
            }
            if (jSONObject.has("enable_vbr_limit")) {
                n3 = jSONObject.getInt("enable_vbr_limit");
                DebugLog.d("zhengjijian", n + " enable_vbr_limit " + n3);
                this.setEnableVBRLimit(n3 == 1);
            }
            if (jSONObject.has("adapt_br_step")) {
                n3 = jSONObject.getInt("adapt_br_step");
                DebugLog.d("configdata", n + " adapt_br_step " + n3);
                this.setAdapt_br_step(n3);
            }
            if (jSONObject.has("adapt_br_min")) {
                n3 = jSONObject.getInt("adapt_br_min");
                DebugLog.d("configdata", n + " adapt_br_min " + n3);
                this.setAdapt_br_min(n3);
            }
            if (jSONObject.has("adapt_fr_min")) {
                n3 = jSONObject.getInt("adapt_fr_min");
                DebugLog.d("configdata", n + " adapt_fr_min " + n3);
                this.setAdapt_fr_min(n3);
            }
            if (jSONObject.has("quic_sender_info")) {
                String string2 = jSONObject.getString("quic_sender_info");
                Log.e((String)"configdata", (String)(n + ", quic_config " + string2));
                this.setProxyConfig(string2);
            }
            if (jSONObject.has("quic_adapt_br_min") && jSONObject.has("enable_quic_push_bitrate_change")) {
                int n4 = Integer.parseInt(jSONObject.getString("quic_adapt_br_min"));
                n2 = Integer.parseInt(jSONObject.getString("enable_quic_push_bitrate_change"));
                this.setProxyAdaptConfig(n4, n2);
            }
            if (jSONObject.has("adapt_size") && this.isAdaptSizeListEmpty()) {
                JSONArray jSONArray = jSONObject.getJSONArray("adapt_size");
                DebugLog.d("configdata", "player adapt_size " + jSONArray.length());
                for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                    int n5 = jSONArray.getJSONObject(n2).optInt("br", -1);
                    int n6 = jSONArray.getJSONObject(n2).optInt("width", -1);
                    int n7 = jSONArray.getJSONObject(n2).optInt("height", -1);
                    this.addAdaptSizeItem(n5, n6, n7);
                    DebugLog.d("configdata", "br " + n5 + " w " + n6 + " h " + n7);
                }
                this.sortAdaptSizeList();
            }
            if (jSONObject.has("beauty_config")) {
                JSONObject jSONObject2 = jSONObject.optJSONObject("beauty_config");
                this.use_new_whiten = jSONObject2.optInt("use_new_whiten");
                JSONArray jSONArray = jSONObject2.optJSONArray("use_usm");
                if (jSONArray != null) {
                    this.usm_enable = jSONArray.optInt(0);
                    this.usm_value_sharp = (float)jSONArray.optInt(1) / 100.0f;
                    this.usm_value_saturation = (float)jSONArray.optInt(2) / 100.0f;
                    DebugLog.d("configdata", "beauty_config " + jSONArray.toString() + "/" + this.usm_enable + "/" + this.usm_value_sharp + "/" + this.usm_value_saturation);
                } else {
                    DebugLog.d("configdata", "beauty_config no usm");
                }
                this.faceSkip = jSONObject2.optInt("faceSkip", 1);
            }
            this.enable_audio_high_quality = jSONObject.optInt("enable_audio_high_quality");
            this.enable_audio_media_headset = jSONObject.optInt("enable_audio_media_headset");
            this.adapt_denoise_level = jSONObject.optInt("adapt_denoise_level");
        }
        catch (JSONException jSONException) {
            jSONObject = null;
        }
    }

    public int getAdaptDenoiseLevel() {
        return this.adapt_denoise_level;
    }

    public boolean getEnableAudioMediaHeadset() {
        return this.enable_audio_media_headset == 1;
    }

    public boolean getUsmEnable() {
        return this.usm_enable == 1;
    }

    public float getUsmSharp() {
        return this.usm_value_sharp;
    }

    public float getUsmSaturation() {
        return this.usm_value_saturation;
    }

    public int getUseNewWhiten() {
        return this.use_new_whiten;
    }

    public int getFaceSkip() {
        return this.faceSkip;
    }

    public void setEnableV3LogReport(boolean bl) {
        this.enableV3LogReport = bl;
    }

    public boolean isEnableV3LogReport() {
        return this.enableV3LogReport;
    }

    public boolean isEnableWeilaVBR() {
        return this.enableWeilaVBR;
    }

    public void setEnableWeilaVBR(boolean bl) {
        this.enableWeilaVBR = bl;
    }

    private void setEnableVBRLimit(boolean bl) {
        this.enableVBRLimit = bl;
    }

    public boolean getEnableVBRLimit() {
        return this.enableVBRLimit;
    }

    public int getAdapt_br_step() {
        return this.adapt_br_step;
    }

    private void setAdapt_br_step(int n) {
        this.adapt_br_step = n;
    }

    public int getAdapt_br_min() {
        return this.adapt_br_min;
    }

    private void setAdapt_br_min(int n) {
        this.adapt_br_min = n;
    }

    public int getAdapt_fr_min() {
        return this.adapt_fr_min;
    }

    private void setAdapt_fr_min(int n) {
        this.adapt_fr_min = n;
    }

    public boolean isAdaptBrFrUpdated() {
        return this.adapt_br_step != -1 && this.adapt_br_min != -1 && this.adapt_fr_min != -1;
    }

    private void setProxyConfig(String string) {
        this.mQuicProxyConfig = string;
    }

    public boolean hasProxyConfig() {
        return this.mQuicProxyConfig != null;
    }

    public String getProxyConfig() {
        return this.mQuicProxyConfig;
    }

    private void setProxyAdaptConfig(int n, int n2) {
        this.quic_adapt_br_min = n;
    }

    public boolean hasProxyAdaptConfig() {
        return this.quic_adapt_br_min != -1;
    }

    public String getProxyAdaptConfig(int n) {
        return "{maxBitrate:" + n + "," + "minBitrate:" + this.quic_adapt_br_min + "}";
    }

    public int getEnableAudioHighQuality() {
        return this.enable_audio_high_quality;
    }

    public List<AdaptSizeItem> getAdaptSizeList() {
        return this.mAdaptSizeList;
    }

    public boolean isAdaptSizeListEmpty() {
        return this.mAdaptSizeList.isEmpty();
    }

    private void addAdaptSizeItem(int n, int n2, int n3) {
        this.mAdaptSizeList.add(new AdaptSizeItem(n, n2, n3));
    }

    private void sortAdaptSizeList() {
        Collections.sort(this.mAdaptSizeList);
        for (AdaptSizeItem adaptSizeItem : this.mAdaptSizeList) {
            DebugLog.d("configdata", adaptSizeItem.toString());
        }
    }

    public boolean isNtpTimeInited() {
        return this.mNtpUpdateTimeMs != 0L;
    }

    public void setRefreshTimeDeltMs(long l) {
        if (l >= 60000L) {
            this.refreshTimeDeltMs = l;
        }
    }

    public boolean isNtpTimeNeedRefresh() {
        return !this.isNtpTimeInited() || this.getNtpCurrentTimeMillis() - this.mNtpUpdateTimeMs > this.refreshTimeDeltMs;
    }

    public void setNtpCurrentTimeMillis(long l, long l2) {
        this.mNtpUpdateTimeMs = l + l2;
        this.ntpDeltMs = System.currentTimeMillis() - this.mNtpUpdateTimeMs;
        DebugLog.pf("HttpRequester", "momoNtpTimeMs " + this.ntpDeltMs + " / cost " + l2);
    }

    public long getNtpCurrentTimeMillis() {
        long l = System.currentTimeMillis() - this.ntpDeltMs;
        return l;
    }

    public class AdaptSizeItem
    implements Comparable<AdaptSizeItem> {
        Integer br;
        int w;
        int h;

        public AdaptSizeItem(int n, int n2, int n3) {
            this.br = n;
            this.w = n2;
            this.h = n3;
        }

        @Override
        public int compareTo(@NonNull AdaptSizeItem adaptSizeItem) {
            return adaptSizeItem.getBr().compareTo(this.getBr());
        }

        public Integer getBr() {
            return this.br;
        }

        public int getW() {
            return this.w;
        }

        public int getH() {
            return this.h;
        }

        public String toString() {
            return "AdaptSizeItem{br=" + this.br + ", w=" + this.w + ", h=" + this.h + '}';
        }
    }

    private static class Sigleton {
        private static MediaConfigsForIJK sInstance = new MediaConfigsForIJK();

        private Sigleton() {
        }
    }
}

