/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import com.immomo.baseutil.DebugLog;
import com.immomo.baseutil.MediaConfigsForIJK;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpRequester {
    private final OkHttpClient client = new OkHttpClient();

    public static HttpRequester getInstance() {
        return Sigleton.sInstance;
    }

    private HttpRequester() {
    }

    public void updateNtpTime() {
        Request request = new Request.Builder().url("https://live-api.immomo.com/ext/server/time").build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException iOException) {
                DebugLog.pf("HttpRequester", "updateNtpTime onFailure");
                iOException.printStackTrace();
            }

            public void onResponse(Call call, Response response) {
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                long l = 0L;
                long l2 = 0L;
                Headers headers = response.headers();
                for (int i = 0; i < headers.size(); ++i) {
                    DebugLog.pf("HttpRequester", headers.name(i) + ": " + headers.value(i));
                    if ("OkHttp-Sent-Millis".equals(headers.name(i))) {
                        l = Long.valueOf(headers.value(i));
                    }
                    if (!"OkHttp-Received-Millis".equals(headers.name(i))) continue;
                    l2 = Long.valueOf(headers.value(i));
                }
                try {
                    JSONObject jSONObject = new JSONObject(response.body().string());
                    DebugLog.pf("HttpRequester", jSONObject.toString());
                    if (jSONObject.has("millisecond")) {
                        long l3 = jSONObject.getLong("millisecond");
                        MediaConfigsForIJK.getInstance().setNtpCurrentTimeMillis(l3, l2 - l);
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        });
    }

    private static class Sigleton {
        private static HttpRequester sInstance = new HttpRequester();

        private Sigleton() {
        }
    }
}

