/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.util.Log;
import com.immomo.baseutil.Pragma;
import java.util.Locale;

public class DebugLog {
    public static final boolean ENABLE_ERROR = Pragma.ENABLE_VERBOSE;
    public static final boolean ENABLE_INFO = Pragma.ENABLE_VERBOSE;
    public static final boolean ENABLE_WARN = Pragma.ENABLE_VERBOSE;
    public static final boolean ENABLE_DEBUG = Pragma.ENABLE_VERBOSE;
    public static final boolean ENABLE_VERBOSE = Pragma.ENABLE_VERBOSE;

    public static int e(String string, String string2) {
        if (ENABLE_ERROR) {
            return Log.e((String)string, (String)string2);
        }
        return 0;
    }

    public static int e(String string, String string2, Throwable throwable) {
        if (ENABLE_ERROR) {
            return Log.e((String)string, (String)string2, (Throwable)throwable);
        }
        return 0;
    }

    public static int efmt(String string, String string2, Object ... objectArray) {
        if (ENABLE_ERROR) {
            String string3 = String.format(Locale.US, string2, objectArray);
            return Log.e((String)string, (String)string3);
        }
        return 0;
    }

    public static int i(String string, String string2) {
        if (ENABLE_INFO) {
            return Log.i((String)string, (String)string2);
        }
        return 0;
    }

    public static int i(String string, String string2, Throwable throwable) {
        if (ENABLE_INFO) {
            return Log.i((String)string, (String)string2, (Throwable)throwable);
        }
        return 0;
    }

    public static int ifmt(String string, String string2, Object ... objectArray) {
        if (ENABLE_INFO) {
            String string3 = String.format(Locale.US, string2, objectArray);
            return Log.i((String)string, (String)string3);
        }
        return 0;
    }

    public static int w(String string, String string2) {
        if (ENABLE_WARN) {
            return Log.w((String)string, (String)string2);
        }
        return 0;
    }

    public static int w(String string, String string2, Throwable throwable) {
        if (ENABLE_WARN) {
            return Log.w((String)string, (String)string2, (Throwable)throwable);
        }
        return 0;
    }

    public static int wfmt(String string, String string2, Object ... objectArray) {
        if (ENABLE_WARN) {
            String string3 = String.format(Locale.US, string2, objectArray);
            return Log.w((String)string, (String)string3);
        }
        return 0;
    }

    public static int d(String string, String string2) {
        if (ENABLE_DEBUG) {
            return Log.d((String)string, (String)string2);
        }
        return 0;
    }

    public static int d(String string, String string2, Throwable throwable) {
        if (ENABLE_DEBUG) {
            return Log.d((String)string, (String)string2, (Throwable)throwable);
        }
        return 0;
    }

    public static int dfmt(String string, String string2, Object ... objectArray) {
        if (ENABLE_DEBUG) {
            String string3 = String.format(Locale.US, string2, objectArray);
            return Log.d((String)string, (String)string3);
        }
        return 0;
    }

    public static int v(String string, String string2) {
        if (ENABLE_VERBOSE) {
            return Log.v((String)string, (String)string2);
        }
        return 0;
    }

    public static int v(String string, String string2, Throwable throwable) {
        if (ENABLE_VERBOSE) {
            return Log.v((String)string, (String)string2, (Throwable)throwable);
        }
        return 0;
    }

    public static int vfmt(String string, String string2, Object ... objectArray) {
        if (ENABLE_VERBOSE) {
            String string3 = String.format(Locale.US, string2, objectArray);
            return Log.v((String)string, (String)string3);
        }
        return 0;
    }

    public static void printStackTrace(Throwable throwable) {
        if (ENABLE_WARN) {
            throwable.printStackTrace();
        }
    }

    public static void printCause(Throwable throwable) {
        if (ENABLE_WARN) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throwable = throwable2;
            }
            DebugLog.printStackTrace(throwable);
        }
    }

    public static int TRACE(String string, Object object) {
        if (ENABLE_DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                if (stackTraceElement.getFileName().contains("DebugLog.java") || stackTraceElement.getMethodName().contains("getStackTrace") || stackTraceElement.getMethodName().contains("getThreadStackTrace") || stackTraceElement.getClassName().startsWith("android.os") || stackTraceElement.getClassName().startsWith("java.") || stackTraceElement.getFileName().contains("ZygoteInit.java")) continue;
                stringBuilder.append(stackTraceElement.getFileName() + "[" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + "]\n");
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(" ");
                }
                ++n;
            }
            return Log.d((String)string, (String)(stringBuilder.toString() + object));
        }
        return 0;
    }

    public static int pf(String string, Object object) {
        if (ENABLE_DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "";
            int n = 0;
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                if (stackTraceElement.getFileName().contains("DebugLog.java") || stackTraceElement.getMethodName().contains("getStackTrace") || stackTraceElement.getMethodName().contains("getThreadStackTrace") || stackTraceElement.getClassName().startsWith("android.os") || stackTraceElement.getClassName().startsWith("java.") || stackTraceElement.getFileName().contains("ZygoteInit.java")) continue;
                stringBuilder.append(stackTraceElement.getFileName() + "[" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + "]\n");
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(" ");
                }
                if (n == 0) {
                    string2 = stackTraceElement.getFileName() + "[" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + "] ";
                    return Log.d((String)string, (String)(string2 + object));
                }
                ++n;
            }
            return Log.d((String)string, (String)(string2 + object));
        }
        return 0;
    }
}

