/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import com.immomo.baseutil.CpuBenchmarkListener;
import com.immomo.baseutil.CpuFLOPSAndIOPSListener;
import com.immomo.baseutil.CpuFLOPSBenchmark;
import com.immomo.baseutil.CpuIOPSBenchmark;
import com.immomo.baseutil.DebugLog;

public class CpuBenchmark {
    private double mCpuFLOPS;
    private double mCpuIOPS;
    private int FLOPSCnt = 0;
    private int IOPSCnt = 0;
    private static final String TAG = "CpuBenchmark";
    private CpuBenchmarkListener mCpuBenchmarkListener = null;

    public void setCpuBenchmarkListener(CpuBenchmarkListener cpuBenchmarkListener) {
        this.mCpuBenchmarkListener = cpuBenchmarkListener;
    }

    public void FLOPSBenchmark(final int n, long l) {
        int n2;
        CpuFLOPSBenchmark[] cpuFLOPSBenchmarkArray = new CpuFLOPSBenchmark[n];
        for (n2 = 0; n2 < n; ++n2) {
            cpuFLOPSBenchmarkArray[n2] = new CpuFLOPSBenchmark(l);
            cpuFLOPSBenchmarkArray[n2].setBenchmarkListener(new CpuFLOPSAndIOPSListener(){

                @Override
                public void CpuFLOPSFinish(double d) {
                    CpuBenchmark.this.FLOPSCnt++;
                    CpuBenchmark.this.mCpuFLOPS = CpuBenchmark.this.mCpuFLOPS + d / (double)n;
                    if (CpuBenchmark.this.FLOPSCnt == n) {
                        CpuBenchmark.this.mCpuBenchmarkListener.getCpuFLOPS(CpuBenchmark.this.mCpuFLOPS);
                        DebugLog.i(CpuBenchmark.TAG, "The mCpuFLOPS is " + CpuBenchmark.this.mCpuFLOPS);
                    }
                }

                @Override
                public void CpuIOPSFinish(double d) {
                }
            });
            cpuFLOPSBenchmarkArray[n2].start();
        }
        for (n2 = 0; n2 < n; ++n2) {
            try {
                cpuFLOPSBenchmarkArray[n2].join();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DebugLog.i(TAG, "Interrupted !!!");
            }
        }
    }

    public void IOPSBenchmark(final int n, long l) {
        int n2;
        CpuIOPSBenchmark[] cpuIOPSBenchmarkArray = new CpuIOPSBenchmark[n];
        for (n2 = 0; n2 < n; ++n2) {
            cpuIOPSBenchmarkArray[n2] = new CpuIOPSBenchmark(l);
            cpuIOPSBenchmarkArray[n2].setBenchmarkListener(new CpuFLOPSAndIOPSListener(){

                @Override
                public void CpuFLOPSFinish(double d) {
                }

                @Override
                public void CpuIOPSFinish(double d) {
                    CpuBenchmark.this.IOPSCnt++;
                    CpuBenchmark.this.mCpuIOPS = CpuBenchmark.this.mCpuIOPS + d / (double)n;
                    if (CpuBenchmark.this.IOPSCnt == n) {
                        CpuBenchmark.this.mCpuBenchmarkListener.getCpuIOPS(CpuBenchmark.this.mCpuIOPS);
                        DebugLog.i(CpuBenchmark.TAG, "The mCpuIOPS is " + CpuBenchmark.this.mCpuIOPS);
                    }
                }
            });
            cpuIOPSBenchmarkArray[n2].start();
        }
        for (n2 = 0; n2 < n; ++n2) {
            try {
                cpuIOPSBenchmarkArray[n2].join();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DebugLog.i(TAG, "Interrupted !!!");
            }
        }
    }
}

