/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import com.immomo.baseutil.DebugLog;
import com.immomo.baseutil.MediaStatisticModel;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class BatteryMetrics
extends BroadcastReceiver {
    private static final String TAG = "BatteryMetrics";
    private static volatile BatteryMetrics instance = null;
    private StringBuilder stringBuilder = new StringBuilder();
    private int mPhoneSignalLevel = 0;
    private TelephonyManager mTelephonyManager;
    private MyPhoneStateListener mListener = new MyPhoneStateListener();
    private int batteryRemin = 0;
    private int batteryStatus = 0;

    private BatteryMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BatteryMetrics getInstance() {
        if (instance != null) return instance;
        Class<BatteryMetrics> clazz = BatteryMetrics.class;
        synchronized (BatteryMetrics.class) {
            if (instance != null) return instance;
            instance = new BatteryMetrics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context) {
        context.registerReceiver((BroadcastReceiver)this, this.getFilter());
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (this.mTelephonyManager != null) {
            this.mTelephonyManager.listen((PhoneStateListener)this.mListener, 256);
        }
    }

    public void uninit(Context context) {
        block3: {
            try {
                if (this.mTelephonyManager != null) {
                    this.mTelephonyManager.listen((PhoneStateListener)this.mListener, 0);
                }
                context.unregisterReceiver((BroadcastReceiver)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (illegalArgumentException.getMessage().contains("Receiver not registered")) break block3;
                throw illegalArgumentException;
            }
        }
    }

    public String getInfo() {
        return this.stringBuilder.toString();
    }

    public int getBatteryRemin() {
        return this.batteryRemin;
    }

    public String getBatteryStatus() {
        return this.batteryStatus == 0 ? "uncharged" : (this.batteryStatus == 1 ? "charging" : "full");
    }

    public String getBatteryInfo() {
        return String.valueOf(this.batteryRemin + "," + (this.batteryStatus == 0 ? "uncharged" : (this.batteryStatus == 1 ? "charging" : "full")));
    }

    public void onReceive(Context context, Intent intent) {
        if (intent != null && ("android.net.wifi.WIFI_STATE_CHANGED".equalsIgnoreCase(intent.getAction()) || "android.net.wifi.RSSI_CHANGED".equalsIgnoreCase(intent.getAction()))) {
            this.getWifiInfo(context);
            return;
        }
        this.stringBuilder.setLength(0);
        if (intent != null && "android.intent.action.BATTERY_CHANGED".equalsIgnoreCase(intent.getAction())) {
            this.batteryRemin = intent.getIntExtra("level", -1);
            this.stringBuilder.append("\u5f53\u524d\u7535\u91cf\uff1a" + this.batteryRemin + "\n");
            int n = intent.getIntExtra("scale", -1);
            this.stringBuilder.append("\u6700\u5927\u7535\u91cf\uff1a" + n + "\n");
            int n2 = intent.getIntExtra("voltage", -1);
            this.stringBuilder.append("\u5f53\u524d\u7535\u538b\uff1a" + n2 + "\n");
            this.getEXTRA_HEALTH(intent.getIntExtra("health", -1));
            this.getEXTRA_STATUS(intent.getIntExtra("status", -1));
            this.getEXTRA_PLUGGED(intent.getIntExtra("plugged", -1));
            String string = intent.getStringExtra("technology");
            int n3 = intent.getIntExtra("temperature", -1);
            this.stringBuilder.append("\u7535\u538b\uff1a" + n2 + " \u7535\u6c60\uff1a" + string + " \u6e29\u5ea6\uff1a" + (double)((float)n3 / 10.0f) + "\n");
        } else if (intent != null && "android.intent.action.BATTERY_LOW".equalsIgnoreCase(intent.getAction())) {
            this.stringBuilder.append("\t\t\u7535\u91cf\u4f4e\n");
        } else if (intent != null && "android.intent.action.BATTERY_OKAY".equalsIgnoreCase(intent.getAction())) {
            this.stringBuilder.append("\t\t\u7535\u91cf\u6b63\u5e38\n");
        }
        DebugLog.d(TAG, "get update: " + this.stringBuilder.toString());
    }

    private IntentFilter getFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
        intentFilter.addAction("android.intent.action.BATTERY_LOW");
        intentFilter.addAction("android.intent.action.BATTERY_OKAY");
        intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        intentFilter.addAction("android.net.wifi.RSSI_CHANGED");
        return intentFilter;
    }

    private void getEXTRA_HEALTH(int n) {
        switch (n) {
            case 2: {
                this.stringBuilder.append("\u5f53\u524d\u72b6\u6001\uff1aBATTERY_HEALTH_GOOD\n");
                break;
            }
            case 7: {
                this.stringBuilder.append("\u5f53\u524d\u72b6\u6001\uff1aBATTERY_HEALTH_COLD\n");
                break;
            }
            case 4: {
                this.stringBuilder.append("\u5f53\u524d\u72b6\u6001\uff1aBATTERY_HEALTH_DEAD\n");
                break;
            }
            case 3: {
                this.stringBuilder.append("\u5f53\u524d\u72b6\u6001\uff1aBATTERY_HEALTH_OVERHEAT\n");
                break;
            }
            case 5: {
                this.stringBuilder.append("\u5f53\u524d\u72b6\u6001\uff1aBATTERY_HEALTH_OVER_VOLTAGE\n");
                break;
            }
            case 1: {
                this.stringBuilder.append("\u5f53\u524d\u72b6\u6001\uff1aBATTERY_HEALTH_UNKNOWN\n");
                break;
            }
            case 6: {
                this.stringBuilder.append("\u5f53\u524d\u72b6\u6001\uff1aBATTERY_HEALTH_UNSPECIFIED_FAILURE\n");
                break;
            }
        }
    }

    private void getEXTRA_STATUS(int n) {
        switch (n) {
            case 2: {
                this.batteryStatus = 1;
                this.stringBuilder.append("\u5145\u7535\uff1a\u6b63\u5728\u5145\u7535\n");
                break;
            }
            case 3: {
                this.batteryStatus = 0;
                this.stringBuilder.append("\u5145\u7535\uff1a\u6389\u7535\u4e2d\n");
                break;
            }
            case 5: {
                this.batteryStatus = 2;
                this.stringBuilder.append("\u5145\u7535\uff1a\u5145\u6ee1\n");
                break;
            }
            case 4: {
                this.batteryStatus = 0;
                this.stringBuilder.append("\u5145\u7535\uff1a\u672a\u5145\u7535\n");
                break;
            }
            case 1: {
                this.stringBuilder.append("\u5145\u7535\uff1a\u672a\u77e5\n");
                break;
            }
        }
    }

    private void getEXTRA_PLUGGED(int n) {
        switch (n) {
            case 0: {
                this.stringBuilder.append("\u662f\u5426\u63a5\u5165\u7535\u6e90\uff1a\u6ca1\u6709\n");
                break;
            }
            case 1: {
                this.stringBuilder.append("\u662f\u5426\u63a5\u5165\u7535\u6e90\uff1aAC\n");
                break;
            }
            case 2: {
                this.stringBuilder.append("\u662f\u5426\u63a5\u5165\u7535\u6e90\uff1aUSB\n");
                break;
            }
        }
    }

    private void getWifiInfo(Context context) {
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        WifiInfo wifiInfo = null;
        if (wifiManager != null) {
            wifiInfo = wifiManager.getConnectionInfo();
        }
        if (wifiInfo != null && wifiInfo.getBSSID() != null) {
            String string = wifiInfo.getSSID();
            int n = wifiInfo.getRssi();
            int n2 = WifiManager.calculateSignalLevel((int)n, (int)5);
            int n3 = wifiInfo.getLinkSpeed();
            MediaStatisticModel.getInstance().setSignalStrength(n2);
            MediaStatisticModel.getInstance().setWifiOrOther("wifi");
            DebugLog.d("NetUtils", "ssid " + string + " level " + n2 + ",speed " + n3 + ",rssi " + n);
        } else {
            MediaStatisticModel.getInstance().setSignalStrength(this.mPhoneSignalLevel);
            MediaStatisticModel.getInstance().setWifiOrOther("other");
            DebugLog.d("NetUtils", "wifi down.");
        }
    }

    public String getIpAddr() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        return "";
    }

    private class MyPhoneStateListener
    extends PhoneStateListener {
        private MyPhoneStateListener() {
        }

        public void onSignalStrengthChanged(int n) {
            super.onSignalStrengthChanged(n);
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            if (Build.VERSION.SDK_INT >= 23) {
                BatteryMetrics.this.mPhoneSignalLevel = signalStrength.getLevel();
            }
            DebugLog.d("NetUtils", "signalStrength " + signalStrength.toString());
        }
    }
}

