/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.videoprocessor;

import android.util.Log;
import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.videoprocessor.VideoInfo;
import com.momocv.videoprocessor.VideoParams;

public class VideoProcessor {
    private static boolean initok = true;
    private long mOBJPtr = 0L;
    private boolean inited = false;

    static boolean init() {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            return true;
        }
        try {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            UnsatisfiedLinkError primaryLibException = e;
            Log.e((String)"mmcv", (String)("failed to load native library" + primaryLibException.getMessage()));
            initok = false;
            return false;
        }
    }

    public VideoProcessor() {
        this.Create();
    }

    public synchronized void Create() {
        if (!initok) {
            return;
        }
        this.Release();
        this.mOBJPtr = VideoProcessor.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            VideoProcessor.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String fd_model_file, String fa_model_file) {
        if (!initok) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] fd_model_buf = ReadFile2Bytes.StringPath2Bytes(fd_model_file);
            byte[] fa_model_buf = ReadFile2Bytes.StringPath2Bytes(fa_model_file);
            this.inited = VideoProcessor.nativeLoadModel(this.mOBJPtr, fd_model_buf, fa_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] fd_model, byte[] fa_model) {
        if (!initok) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = VideoProcessor.nativeLoadModel(this.mOBJPtr, fd_model, fa_model);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, VideoParams video_params, VideoInfo ret_info) {
        if (!initok) {
            return false;
        }
        if (this.mOBJPtr != 0L && this.inited) {
            if (frame.format_ == 17 && frame.data_len_ != frame.height_ * frame.width_ * 3 / 2) {
                Log.e((String)"mmcv", (String)("_frame.data_len_ < _frame.height_ * _frame.step_ / 2 * 3frame.width_ " + frame.width_ + "frame.height_" + frame.height_ + "frame.data_len_" + frame.data_len_));
                return false;
            }
            return VideoProcessor.nativeProcessFrame(this.mOBJPtr, frame, video_params, ret_info);
        }
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2, byte[] var3);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, VideoParams var3, VideoInfo var4);

    static {
        VideoProcessor.init();
    }
}

