/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.segmentation;

import android.util.Log;
import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.segmentation.SegmentationInfo;
import com.momocv.segmentation.SegmentationParams;

public class Segmentation {
    private static boolean initok = true;
    private boolean releasing = false;
    private long mOBJPtr = 0L;
    private boolean inited = false;

    static boolean init() {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_segmentation");
            return true;
        }
        try {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_segmentation");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            UnsatisfiedLinkError primaryLibException = e;
            Log.e((String)"mmcv", (String)("failed to load native library" + primaryLibException.getMessage()));
            initok = false;
            return false;
        }
    }

    public Segmentation() {
        this.Create();
    }

    public synchronized void Create() {
        if (!initok) {
            return;
        }
        if (!this.releasing) {
            this.mOBJPtr = Segmentation.nativeCreate();
        }
    }

    private synchronized void ReleaseFunctor() {
        if (this.mOBJPtr != 0L) {
            Segmentation.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
        this.releasing = false;
    }

    public synchronized void Release() {
        this.releasing = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Segmentation.this.ReleaseFunctor();
            }
        }, "segmentationRelease").start();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String model_file) {
        if (!initok) {
            return false;
        }
        if (OsUtils.maceSyncLoading()) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = Segmentation.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModelSync(String model_file) {
        if (!initok) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = Segmentation.nativeLoadModelSync(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf) {
        if (!initok) {
            return false;
        }
        if (OsUtils.maceSyncLoading()) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = Segmentation.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModelSync(byte[] model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = Segmentation.nativeLoadModelSync(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, SegmentationParams params, SegmentationInfo mask) {
        if (!initok) {
            return false;
        }
        if (OsUtils.maceSyncLoading()) {
            return false;
        }
        if (this.mOBJPtr != 0L && this.inited) {
            return Segmentation.nativeProcessFrame(this.mOBJPtr, frame, params, mask);
        }
        return false;
    }

    public synchronized void Reset() {
        if (!initok) {
            return;
        }
        if (this.mOBJPtr != 0L) {
            Segmentation.nativeReset(this.mOBJPtr);
        }
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native void nativeReset(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeLoadModelSync(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, SegmentationParams var3, SegmentationInfo var4);

    static {
        Segmentation.init();
    }
}

