/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.pickercover;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.pickercover.PickerCoverInfo;
import com.momocv.videoprocessor.VideoParams;

public class PickerCover {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public PickerCover() {
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = this.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            this.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String fd_model_file, String fa_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] fd_model_buf = ReadFile2Bytes.StringPath2Bytes(fd_model_file);
            byte[] fa_model_buf = ReadFile2Bytes.StringPath2Bytes(fa_model_file);
            this.inited = PickerCover.nativeLoadModel(this.mOBJPtr, fd_model_buf, fa_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] fd_model_buf, byte[] fa_model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = PickerCover.nativeLoadModel(this.mOBJPtr, fd_model_buf, fa_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, VideoParams videoparams, PickerCoverInfo pickercoverinfo) {
        boolean ret_val = false;
        if (this.mOBJPtr != 0L && this.inited) {
            ret_val = this.nativeProcessFrame(this.mOBJPtr, frame, videoparams, pickercoverinfo);
        }
        return ret_val;
    }

    private native long nativeCreate();

    private native void nativeRelease(long var1);

    private static native boolean nativeLoadModel(long var0, byte[] var2, byte[] var3);

    private native boolean nativeProcessFrame(long var1, MMFrame var3, VideoParams var4, PickerCoverInfo var5);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_pickercover");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_pickercover");
        }
    }
}

