/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.objecttracker;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.objecttracker.ObjectTrackerInfo;
import com.momocv.objecttracker.ObjectTrackerParams;

public class ObjectTracker {
    public int num_orientation = 5;
    public int n = 3;
    public int N = 10;
    public boolean enable_detect_scale = true;
    public boolean enable_detect_loss = false;
    public boolean update_model = true;
    private long mOBJ = 0L;

    public ObjectTracker() {
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJ = this.nativeCreate(this.mOBJ, this.num_orientation, this.n, this.N, this.enable_detect_scale, this.enable_detect_loss, this.update_model);
    }

    public synchronized void Release() {
        if (this.mOBJ != 0L) {
            this.nativeRelease(this.mOBJ);
            this.mOBJ = 0L;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean ReInit(MMFrame frame, ObjectTrackerParams params) {
        if (this.mOBJ != 0L) {
            return ObjectTracker.nativeReInit(this.mOBJ, frame, params);
        }
        return false;
    }

    public synchronized boolean Update(MMFrame frame, ObjectTrackerParams params, ObjectTrackerInfo ret_info) {
        if (this.mOBJ != 0L) {
            return ObjectTracker.nativeUpdate(this.mOBJ, frame, params, ret_info);
        }
        return false;
    }

    private native long nativeCreate(long var1, int var3, int var4, int var5, boolean var6, boolean var7, boolean var8);

    private native void nativeRelease(long var1);

    private static native boolean nativeReInit(long var0, MMFrame var2, ObjectTrackerParams var3);

    private static native boolean nativeUpdate(long var0, MMFrame var2, ObjectTrackerParams var3, ObjectTrackerInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_objecttracker");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_objecttracker");
        }
    }
}

