/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.objectdetect;

import android.util.Log;
import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.objectdetect.ObjectDetectInfo;
import com.momocv.objectdetect.ObjectDetectParams;

public class ObjectDetect {
    private static boolean initok = true;
    private long mOBJPtr = 0L;
    private boolean inited = false;

    static boolean init() {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_objectdetect");
            return true;
        }
        try {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_objectdetect");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            UnsatisfiedLinkError primaryLibException = e;
            Log.e((String)"mmcv", (String)("failed to load native library" + primaryLibException.getMessage()));
            initok = false;
            return false;
        }
    }

    public ObjectDetect() {
        if (!initok) {
            return;
        }
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = ObjectDetect.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            ObjectDetect.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String object_detect_model_file) {
        if (!initok) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] object_detect_model_buf = ReadFile2Bytes.StringPath2Bytes(object_detect_model_file);
            this.inited = ObjectDetect.nativeLoadModel(this.mOBJPtr, object_detect_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] object_detect_model) {
        if (!initok) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = ObjectDetect.nativeLoadModel(this.mOBJPtr, object_detect_model);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, ObjectDetectParams objectdetect_params, ObjectDetectInfo ret_objectdetect_info) {
        if (!initok) {
            return false;
        }
        if (this.mOBJPtr != 0L && this.inited) {
            return ObjectDetect.nativeProcessFrame(this.mOBJPtr, frame, objectdetect_params, ret_objectdetect_info);
        }
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, ObjectDetectParams var3, ObjectDetectInfo var4);

    static {
        ObjectDetect.init();
    }
}

