/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.mangaface;

import android.util.Log;
import com.momocv.OsUtils;
import com.momocv.mangaface.MangaFaceInfo;
import com.momocv.mangaface.MangaFaceParams;

public class MangaFace {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public MangaFace() {
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = MangaFace.nativeCreate();
        if (this.mOBJPtr != 0L) {
            this.inited = true;
        }
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            MangaFace.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public boolean manga_face(MangaFaceParams param, MangaFaceInfo info) {
        if (this.mOBJPtr != 0L && this.inited) {
            return MangaFace.nativeMangaFace(this.mOBJPtr, param, info);
        }
        Log.d((String)"MangaFace", (String)"mOBJPtr != 0 && inited == true");
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeMangaFace(long var0, MangaFaceParams var2, MangaFaceInfo var3);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_mangaface");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_mangaface");
        }
    }
}

