/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.handlandmark;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.handlandmark.HandLandmarkParams;
import com.momocv.handlandmark.HandLandmarkPostInfo;

public class HandLandmark {
    private boolean releasing = false;
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public HandLandmark() {
        this.Create();
    }

    public synchronized void Create() {
        if (!this.releasing) {
            this.mOBJPtr = HandLandmark.nativeCreate();
        }
    }

    private synchronized void ReleaseFunctor() {
        if (this.mOBJPtr != 0L) {
            HandLandmark.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
        this.releasing = false;
    }

    public synchronized void Release() {
        this.releasing = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                HandLandmark.this.ReleaseFunctor();
            }
        }, "HandLandmarkRelease").start();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String model_file) {
        if (OsUtils.maceSyncLoading()) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = HandLandmark.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf) {
        if (OsUtils.maceSyncLoading()) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = HandLandmark.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModelSync(String model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = HandLandmark.nativeLoadModelSync(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModelSync(byte[] model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = HandLandmark.nativeLoadModelSync(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, HandLandmarkParams params, HandLandmarkPostInfo ret_hand) {
        if (OsUtils.maceSyncLoading()) {
            return false;
        }
        if (this.mOBJPtr != 0L && this.inited) {
            return HandLandmark.nativeProcessFrame(this.mOBJPtr, frame, params, ret_hand);
        }
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeLoadModelSync(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, HandLandmarkParams var3, HandLandmarkPostInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_handlandmark");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_handlandmark");
        }
    }
}

