/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.handgesture;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.handgesture.HandGestureInfo;
import com.momocv.handgesture.HandGestureParams;

public class HandGesture {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public HandGesture() {
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = HandGesture.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            HandGesture.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String object_detect_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] object_detect_model_buf = ReadFile2Bytes.StringPath2Bytes(object_detect_model_file);
            this.inited = HandGesture.nativeLoadModel(this.mOBJPtr, object_detect_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] object_detect_model) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = HandGesture.nativeLoadModel(this.mOBJPtr, object_detect_model);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, HandGestureParams objectdetect_params, HandGestureInfo ret_objectdetect_info) {
        if (this.mOBJPtr != 0L && this.inited) {
            return HandGesture.nativeProcessFrame(this.mOBJPtr, frame, objectdetect_params, ret_objectdetect_info);
        }
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, HandGestureParams var3, HandGestureInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("libmmcv_api_handgesture");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_handgesture");
        }
    }
}

