/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.hairseg;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.hairseg.HairSegInfo;
import com.momocv.hairseg.HairSegParams;

public class HairSeg {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public HairSeg() {
        this.Create();
    }

    private void Create() {
        if (this.mOBJPtr != 0L) {
            HairSeg.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = HairSeg.nativeCreate();
    }

    public synchronized boolean LoadModel(String bd_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] bd_model_buf = ReadFile2Bytes.StringPath2Bytes(bd_model_file);
            this.inited = HairSeg.nativeLoadModel(this.mOBJPtr, bd_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = HairSeg.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            HairSeg.nativeRelease(this.mOBJPtr);
            this.inited = false;
            this.mOBJPtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean ProcessFrame(MMFrame frame, HairSegParams baseparam, HairSegInfo hairseginfo) {
        boolean ret_val = false;
        if (this.mOBJPtr != 0L && this.inited) {
            return HairSeg.nativeProcessFrame(this.mOBJPtr, frame, baseparam, hairseginfo);
        }
        return ret_val;
    }

    public synchronized void Reset() {
        if (this.mOBJPtr != 0L) {
            HairSeg.nativeReset(this.mOBJPtr);
        }
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native void nativeReset(long var0);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, HairSegParams var3, HairSegInfo var4);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_hairseg");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_hairseg");
        }
    }
}

