/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.facescanner;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.facescanner.ScannerInfo;
import com.momocv.videoprocessor.VideoParams;

public class FaceScanner {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public FaceScanner() {
        this.Create();
    }

    public synchronized void Reset() {
        if (this.mOBJPtr != 0L) {
            FaceScanner.nativeReset(this.mOBJPtr);
        }
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = FaceScanner.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            FaceScanner.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String fd_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] fd_buf = ReadFile2Bytes.StringPath2Bytes(fd_file);
            this.inited = FaceScanner.nativeLoadModel(this.mOBJPtr, fd_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] fd_model) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = FaceScanner.nativeLoadModel(this.mOBJPtr, fd_model);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, VideoParams video_params, ScannerInfo ret_scanner) {
        if (this.mOBJPtr != 0L && this.inited) {
            return FaceScanner.nativeProcessFrame(this.mOBJPtr, frame, video_params, ret_scanner);
        }
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeReset(long var0);

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, VideoParams var3, ScannerInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_objecttracker");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_facescanner");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_objecttracker");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_facescanner");
        }
    }
}

