/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.facerigv3;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.facerigv3.FacerigV3Info;
import com.momocv.facerigv3.FacerigV3Params;

public class FaceRigV3 {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public FaceRigV3() {
        this.Create();
    }

    private void Create() {
        if (this.mOBJPtr != 0L) {
            FaceRigV3.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = FaceRigV3.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            FaceRigV3.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String frecog_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] frecog_model_buf = ReadFile2Bytes.StringPath2Bytes(frecog_model_file);
            this.inited = FaceRigV3.nativeLoadModel(this.mOBJPtr, frecog_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] frecog_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = FaceRigV3.nativeLoadModel(this.mOBJPtr, frecog_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, FacerigV3Params facerigv3fparams, FacerigV3Info facerigv3_retinfo) {
        boolean ret_val = false;
        if (this.mOBJPtr != 0L) {
            ret_val = FaceRigV3.nativeProcessFrame(this.mOBJPtr, frame, facerigv3fparams, facerigv3_retinfo);
        }
        return ret_val;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, FacerigV3Params var3, FacerigV3Info var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_facerigv3");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_facerigv3");
        }
    }
}

