/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.facerigv2;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.facerigv2.FacerigV2Info;
import com.momocv.facerigv2.FacerigV2Params;

public class FaceRigV2 {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public FaceRigV2() {
        this.Create();
    }

    private void Create() {
        if (this.mOBJPtr != 0L) {
            FaceRigV2.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = FaceRigV2.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            FaceRigV2.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String frecog_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] frecog_model_buf = ReadFile2Bytes.StringPath2Bytes(frecog_model_file);
            this.inited = FaceRigV2.nativeLoadModel(this.mOBJPtr, frecog_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] frecog_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = FaceRigV2.nativeLoadModel(this.mOBJPtr, frecog_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, FacerigV2Params facerigv2fparams, FacerigV2Info facerigv2_retinfo) {
        boolean ret_val = false;
        if (this.mOBJPtr != 0L) {
            ret_val = FaceRigV2.nativeProcessFrame(this.mOBJPtr, frame, facerigv2fparams, facerigv2_retinfo);
        }
        return ret_val;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, FacerigV2Params var3, FacerigV2Info var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_facerig");
            System.loadLibrary("libmmcv_api_facerigv2");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_facerig");
            System.loadLibrary("mmcv_api_facerigv2");
        }
    }
}

