/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.facerig;

import com.momocv.FaceParams;
import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.facerig.FaceRigInfo;

public class FaceRig {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public FaceRig() {
        this.Create();
    }

    private void Create() {
        if (this.mOBJPtr != 0L) {
            FaceRig.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = FaceRig.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            FaceRig.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String frecog_model_file, String fd_model_file, String fa_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] frecog_model_buf = ReadFile2Bytes.StringPath2Bytes(frecog_model_file);
            byte[] fd_model_buf = ReadFile2Bytes.StringPath2Bytes(fd_model_file);
            byte[] fa_model_buf = ReadFile2Bytes.StringPath2Bytes(fa_model_file);
            this.inited = FaceRig.nativeLoadModel(this.mOBJPtr, frecog_model_buf, fd_model_buf, fa_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] frecog_buf, byte[] fd_model_buf, byte[] fa_model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = FaceRig.nativeLoadModel(this.mOBJPtr, frecog_buf, fd_model_buf, fa_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean DetectMeanFace(MMFrame frame, FaceParams faceparams, FaceRigInfo ret_info) {
        boolean ret_val = false;
        if (this.mOBJPtr != 0L) {
            ret_val = FaceRig.nativeDetectMeanFace(this.mOBJPtr, frame, faceparams, ret_info);
        }
        return ret_val;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, FaceParams faceparams, byte[] facerig_feature, FaceRigInfo ret_info) {
        boolean ret_val = false;
        if (this.mOBJPtr != 0L) {
            ret_val = FaceRig.nativeProcessFrame(this.mOBJPtr, frame, faceparams, facerig_feature, ret_info);
        }
        return ret_val;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2, byte[] var3, byte[] var4);

    private static native boolean nativeDetectMeanFace(long var0, MMFrame var2, FaceParams var3, FaceRigInfo var4);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, FaceParams var3, byte[] var4, FaceRigInfo var5);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("libmmcv_api_facerig");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_facerig");
        }
    }
}

