/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.faceregister;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.faceregister.RegisterInfo;
import com.momocv.faceregister.RegisterParams;

public class FaceRegister {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public FaceRegister() {
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = FaceRegister.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            FaceRegister.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = FaceRegister.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(String model_file, String fa_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            byte[] fa_model_buf = ReadFile2Bytes.StringPath2Bytes(fa_model_file);
            this.inited = FaceRegister.nativeLoadModels(this.mOBJPtr, model_buf, fa_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = FaceRegister.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf, byte[] fa_model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = FaceRegister.nativeLoadModels(this.mOBJPtr, model_buf, fa_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, RegisterParams register_params, RegisterInfo ret_register) {
        if (this.mOBJPtr != 0L && this.inited) {
            return FaceRegister.nativeProcessFrame(this.mOBJPtr, frame, register_params, ret_register);
        }
        return false;
    }

    public synchronized void Reset() {
        if (this.mOBJPtr != 0L) {
            FaceRegister.nativeReset(this.mOBJPtr);
        }
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native void nativeReset(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeLoadModels(long var0, byte[] var2, byte[] var3);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, RegisterParams var3, RegisterInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_faceregister");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_faceregister");
        }
    }
}

