/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.facerecog4pet;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.facerecog4pet.FaceRecog4PetInfo;
import com.momocv.videoprocessor.VideoParams;

public class FaceRecog4Pet {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public FaceRecog4Pet() {
        this.Create();
    }

    private void Create() {
        if (this.mOBJPtr != 0L) {
            FaceRecog4Pet.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = FaceRecog4Pet.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            FaceRecog4Pet.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized void Reset() {
        if (this.mOBJPtr != 0L) {
            FaceRecog4Pet.nativeReset(this.mOBJPtr);
        }
    }

    public synchronized boolean LoadModel(String gp_model_file, String fd_model_file, String fa_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] gp_modele_buf = ReadFile2Bytes.StringPath2Bytes(gp_model_file);
            byte[] fd_model_buf = ReadFile2Bytes.StringPath2Bytes(fd_model_file);
            byte[] fa_model_buf = ReadFile2Bytes.StringPath2Bytes(fa_model_file);
            this.inited = FaceRecog4Pet.nativeLoadModel(this.mOBJPtr, gp_modele_buf, fd_model_buf, fa_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] gp_model_buf, byte[] fd_model_buf, byte[] fa_model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = FaceRecog4Pet.nativeLoadModel(this.mOBJPtr, gp_model_buf, fd_model_buf, fa_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, VideoParams videoparams, FaceRecog4PetInfo facerecog4petinfo) {
        boolean ret_val = false;
        if (this.mOBJPtr != 0L && this.inited) {
            ret_val = FaceRecog4Pet.nativeProcessFrame(this.mOBJPtr, frame, videoparams, facerecog4petinfo);
        }
        return ret_val;
    }

    public synchronized byte[] getFeature() {
        byte[] ret_buf = null;
        if (this.mOBJPtr != 0L && this.inited) {
            ret_buf = FaceRecog4Pet.nativeGetFeature(this.mOBJPtr);
        }
        return ret_buf;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2, byte[] var3, byte[] var4);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, VideoParams var3, FaceRecog4PetInfo var4);

    private static native byte[] nativeGetFeature(long var0);

    private static native void nativeReset(long var0);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_facerecog4pet");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_facerecog4pet");
        }
    }
}

