/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.facequality;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.facequality.FaceQualityInfo;
import com.momocv.facequality.FaceQualityParams;

public class FaceQuality {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public FaceQuality() {
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = FaceQuality.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            FaceQuality.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = FaceQuality.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = FaceQuality.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, FaceQualityParams params, FaceQualityInfo ret_info) {
        if (this.mOBJPtr != 0L && this.inited) {
            return FaceQuality.nativeProcessFrame(this.mOBJPtr, frame, params, ret_info);
        }
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, FaceQualityParams var3, FaceQualityInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_facequality");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_facequality");
        }
    }
}

