/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.facefeatures;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.facefeatures.FaceFeaturesInfo;
import com.momocv.facefeatures.FaceFeaturesParams;

public class FaceFeatures {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public FaceFeatures() {
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = FaceFeatures.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            FaceFeatures.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = FaceFeatures.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = FaceFeatures.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized float[] ExtractFeatures(byte[] big_features) {
        if (this.mOBJPtr != 0L && this.inited) {
            return FaceFeatures.nativeExtractFeatures(this.mOBJPtr, big_features);
        }
        return null;
    }

    public synchronized boolean ExtractFeaturesV2(MMFrame frame, FaceFeaturesParams params, FaceFeaturesInfo features) {
        if (this.mOBJPtr != 0L && this.inited) {
            return FaceFeatures.nativeExtractFeatures_v2(this.mOBJPtr, frame, params, features);
        }
        return false;
    }

    public synchronized boolean ExtractFeaturesV3(MMFrame frame, FaceFeaturesParams params, FaceFeaturesInfo features) {
        if (this.mOBJPtr != 0L) {
            return FaceFeatures.nativeExtractFeatures_v3(this.mOBJPtr, frame, params, features);
        }
        return false;
    }

    public synchronized float CompareFeatures(float[] fea_a, float[] fea_b) {
        if (this.mOBJPtr != 0L) {
            return FaceFeatures.nativeCompareFeatures(this.mOBJPtr, fea_a, fea_b);
        }
        return 0.0f;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native float nativeCompareFeatures(long var0, float[] var2, float[] var3);

    private static native float[] nativeExtractFeatures(long var0, byte[] var2);

    private static native boolean nativeExtractFeatures_v2(long var0, MMFrame var2, FaceFeaturesParams var3, FaceFeaturesInfo var4);

    private static native boolean nativeExtractFeatures_v3(long var0, MMFrame var2, FaceFeaturesParams var3, FaceFeaturesInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
        }
    }
}

