/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.express;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.express.ExpressInfo;
import com.momocv.express.ExpressParams;

public class Express {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public Express() {
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = Express.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            Express.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String express_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] express_model_buf = ReadFile2Bytes.StringPath2Bytes(express_model_file);
            this.inited = Express.nativeLoadModel(this.mOBJPtr, express_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] express_model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = Express.nativeLoadModel(this.mOBJPtr, express_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, ExpressParams express_params, ExpressInfo ret_info) {
        if (this.mOBJPtr != 0L && this.inited) {
            return Express.nativeProcessFrame(this.mOBJPtr, frame, express_params, ret_info);
        }
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, ExpressParams var3, ExpressInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_express");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_express");
        }
    }
}

