/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.datarecycle;

import com.momocv.BaseParams;
import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.datarecycle.DataRecycleInfo;

public class DataRecycle {
    private boolean inited = false;
    private long mOBJPtr = 0L;

    public DataRecycle() {
        this.Create();
    }

    private void Create() {
        if (this.mOBJPtr != 0L) {
            DataRecycle.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = DataRecycle.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            DataRecycle.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = DataRecycle.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = DataRecycle.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, BaseParams baseparams, DataRecycleInfo ret) {
        boolean ret_val = false;
        if (this.mOBJPtr != 0L && this.inited) {
            ret_val = DataRecycle.nativeProcessFrame(this.mOBJPtr, frame, baseparams, ret);
        }
        return ret_val;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, BaseParams var3, DataRecycleInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_datarecycle");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_datarecycle");
        }
    }
}

