/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.bodylandmark;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.bodylandmark.BodyLandmarkParams;
import com.momocv.bodylandmark.BodyLandmarkPostInfo;

public class BodyLandmark {
    private boolean releasing = false;
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public BodyLandmark() {
        this.Create();
    }

    public synchronized void Create() {
        if (!this.releasing) {
            this.mOBJPtr = BodyLandmark.nativeCreate();
        }
    }

    private synchronized void ReleaseFunctor() {
        if (this.mOBJPtr != 0L) {
            BodyLandmark.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
        this.releasing = false;
    }

    public synchronized void Release() {
        this.releasing = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                BodyLandmark.this.ReleaseFunctor();
            }
        }, "bodyLandmarksRelease").start();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String model_file) {
        if (OsUtils.maceSyncLoading()) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = BodyLandmark.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf) {
        if (OsUtils.maceSyncLoading()) {
            return false;
        }
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = BodyLandmark.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModelSync(String model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] model_buf = ReadFile2Bytes.StringPath2Bytes(model_file);
            this.inited = BodyLandmark.nativeLoadModelSync(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModelSync(byte[] model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = BodyLandmark.nativeLoadModelSync(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, BodyLandmarkParams params, BodyLandmarkPostInfo ret_body) {
        if (OsUtils.maceSyncLoading()) {
            return false;
        }
        if (this.mOBJPtr != 0L && this.inited) {
            return BodyLandmark.nativeProcessFrame(this.mOBJPtr, frame, params, ret_body);
        }
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    private static native boolean nativeLoadModelSync(long var0, byte[] var2);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, BodyLandmarkParams var3, BodyLandmarkPostInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_bodylandmark");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_bodylandmark");
        }
    }
}

