/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.beauty;

import android.util.Log;
import com.momocv.OsUtils;
import com.momocv.beauty.BeautyWarpInfo;
import com.momocv.beauty.BeautyWarpParams;
import com.momocv.beauty.BodyWarpInfo;
import com.momocv.beauty.BodyWarpParams;

public class BeautyProcessor {
    private static boolean initok = true;
    private long mOBJPtr = 0L;
    private boolean inited = false;

    static boolean init() {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            return true;
        }
        try {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            UnsatisfiedLinkError primaryLibException = e;
            Log.e((String)"mmcv", (String)("failed to load native library" + primaryLibException.getMessage()));
            initok = false;
            return false;
        }
    }

    public BeautyProcessor() {
        this.Create();
    }

    public synchronized void Create() {
        if (!initok) {
            return;
        }
        this.Release();
        this.mOBJPtr = BeautyProcessor.nativeCreate();
        if (this.mOBJPtr != 0L) {
            this.inited = true;
        }
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            BeautyProcessor.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public boolean GetWarpKeyPoints(BeautyWarpParams params, BeautyWarpInfo ret_info) {
        if (!initok) {
            return false;
        }
        if (this.mOBJPtr != 0L && this.inited) {
            return BeautyProcessor.nativeGetWarpKeyPoints(this.mOBJPtr, params, ret_info);
        }
        Log.d((String)"beautyProcessor", (String)"mOBJPtr != 0 && inited == true");
        return false;
    }

    public boolean GetWarpedBodyPoints(BodyWarpParams params, BodyWarpInfo ret_info) {
        if (!initok) {
            return false;
        }
        if (this.mOBJPtr != 0L && this.inited) {
            return BeautyProcessor.nativeGetWarpedBodyPoints(this.mOBJPtr, params, ret_info);
        }
        Log.d((String)"beautyProcessor", (String)"mOBJPtr != 0 && inited == true");
        return false;
    }

    public static void drawChangeFace(float[] face_points, float[] tex_coords, int openglWidth, int openglHeight, int positionHandle, int texCoordHandle) {
        BeautyProcessor.nativeDrawChangeFace(face_points, tex_coords, openglWidth, openglHeight, positionHandle, texCoordHandle);
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeGetWarpKeyPoints(long var0, BeautyWarpParams var2, BeautyWarpInfo var3);

    private static native boolean nativeGetWarpedBodyPoints(long var0, BodyWarpParams var2, BodyWarpInfo var3);

    private static native void nativeDrawChangeFace(float[] var0, float[] var1, int var2, int var3, int var4, int var5);

    static {
        BeautyProcessor.init();
    }
}

