/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.barenessdetect;

import com.momocv.BaseParams;
import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.barenessdetect.BarenessDetectInfo;

public class BarenessDetect {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public BarenessDetect() {
        this.Create();
    }

    private void Create() {
        if (this.mOBJPtr != 0L) {
            BarenessDetect.nativeRelease(this.mOBJPtr);
        }
        this.mOBJPtr = BarenessDetect.nativeCreate();
    }

    public synchronized boolean LoadModel(String bd_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] bd_model_buf = ReadFile2Bytes.StringPath2Bytes(bd_model_file);
            this.inited = BarenessDetect.nativeLoadModel(this.mOBJPtr, bd_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = BarenessDetect.nativeLoadModel(this.mOBJPtr, model_buf);
        }
        return this.inited;
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            BarenessDetect.nativeRelease(this.mOBJPtr);
            this.inited = false;
            this.mOBJPtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean ProcessFrame(MMFrame frame, BaseParams baseparam, BarenessDetectInfo barenessdetectinfo) {
        boolean ret_val = false;
        if (this.mOBJPtr != 0L && this.inited) {
            return BarenessDetect.nativeProcessFrame(this.mOBJPtr, frame, baseparam, barenessdetectinfo);
        }
        return ret_val;
    }

    public synchronized void Reset() {
        if (this.mOBJPtr != 0L) {
            BarenessDetect.nativeReset(this.mOBJPtr);
        }
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native void nativeReset(long var0);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, BaseParams var3, BarenessDetectInfo var4);

    private static native boolean nativeLoadModel(long var0, byte[] var2);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_barenessdetect");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_barenessdetect");
        }
    }
}

