/*
 * Decompiled with CFR 0.152.
 */
package com.momocv.arpet;

import com.momocv.MMFrame;
import com.momocv.OsUtils;
import com.momocv.ReadFile2Bytes;
import com.momocv.arpet.ArpetInfo;
import com.momocv.arpet.ArpetParams;

public class Arpet {
    private long mOBJPtr = 0L;
    private boolean inited = false;

    public Arpet() {
        this.Create();
    }

    public synchronized void Create() {
        this.Release();
        this.mOBJPtr = Arpet.nativeCreate();
    }

    public synchronized void Release() {
        if (this.mOBJPtr != 0L) {
            Arpet.nativeRelease(this.mOBJPtr);
            this.mOBJPtr = 0L;
            this.inited = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Release();
    }

    public synchronized boolean LoadModel(String arpet_model_file, String fd_model_file, String bareness_model_file) {
        if (this.mOBJPtr != 0L && !this.inited) {
            byte[] arpet_model_buf = ReadFile2Bytes.StringPath2Bytes(arpet_model_file);
            byte[] fd_model_buf = ReadFile2Bytes.StringPath2Bytes(fd_model_file);
            byte[] bareness_model_buf = ReadFile2Bytes.StringPath2Bytes(bareness_model_file);
            this.inited = Arpet.nativeLoadModel(this.mOBJPtr, arpet_model_buf, fd_model_buf, bareness_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean LoadModel(byte[] arpet_model_buf, byte[] fd_model_buf, byte[] bareness_model_buf) {
        if (this.mOBJPtr != 0L && !this.inited) {
            this.inited = Arpet.nativeLoadModel(this.mOBJPtr, arpet_model_buf, fd_model_buf, bareness_model_buf);
        }
        return this.inited;
    }

    public synchronized boolean ProcessFrame(MMFrame frame, ArpetParams arpet_params, ArpetInfo ret_info) {
        if (this.mOBJPtr != 0L && this.inited) {
            return Arpet.nativeProcessFrame(this.mOBJPtr, frame, arpet_params, ret_info);
        }
        return false;
    }

    private static native long nativeCreate();

    private static native void nativeRelease(long var0);

    private static native boolean nativeLoadModel(long var0, byte[] var2, byte[] var3, byte[] var4);

    private static native boolean nativeProcessFrame(long var0, MMFrame var2, ArpetParams var3, ArpetInfo var4);

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("libmmcv_api_imagequality");
            System.loadLibrary("libmmcv_api_faceprocessor");
            System.loadLibrary("libmmcv_api_videoprocessor");
            System.loadLibrary("libmmcv_api_barenessdetect");
            System.loadLibrary("libmmcv_api_arpet");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
            System.loadLibrary("mmcv_api_barenessdetect");
            System.loadLibrary("mmcv_api_facerecognition");
            System.loadLibrary("mmcv_api_faceattributes");
            System.loadLibrary("mmcv_api_beauty");
            System.loadLibrary("mmcv_api_imagequality");
            System.loadLibrary("mmcv_api_facefeatures");
            System.loadLibrary("mmcv_api_faceprocessor");
            System.loadLibrary("mmcv_api_videoprocessor");
            System.loadLibrary("mmcv_api_arpet");
        }
    }
}

