/*
 * Decompiled with CFR 0.152.
 */
package com.momocv;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    public static final String SD_PATH = Environment.getExternalStorageDirectory().getPath();
    public static final String FILE_CACHE_PATH = SD_PATH + "/cvmomo";
    public static final String FILE_TEMP_PATH = SD_PATH + "/cvmomo/temp";
    public static final String FILE_LOG_PATH = SD_PATH + "/cvmomo/log";
    public static final String FILE_AVATAR_PATH = SD_PATH + "/cvmomo/avatar";
    public static final String FILE_DRAFT_PATH = SD_PATH + "/cvmomo/draft";
    public static final String FILE_INSTALL_PATH = SD_PATH + "/cvmomo/install";
    public static String UTF_8 = "UTF-8";
    public static String GBK = "GBK";
    public static String ISO_8859_1 = "ISO-8859-1";

    public static File getUpdateApk(int version) {
        if (!new File(FILE_INSTALL_PATH).exists()) {
            new File(FILE_INSTALL_PATH).mkdirs();
        }
        return new File(FILE_INSTALL_PATH + "/liuxing_" + version + ".apk");
    }

    public static String getPhotoFileName() {
        Date date = new Date(System.currentTimeMillis());
        return date.getTime() + ".jpeg";
    }

    public static long getFileSize(File path, FileFilter filter) {
        if (null == path || !path.exists()) {
            return 0L;
        }
        if (path.isFile()) {
            return path.length();
        }
        File[] subFiles = null == filter ? path.listFiles() : path.listFiles(filter);
        long sum = 0L;
        for (File subFile : subFiles) {
            sum += FileUtil.getFileSize(subFile, filter);
        }
        return sum;
    }

    public static void deleteFile(File file, long timeDuration) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (System.currentTimeMillis() - file.lastModified() < timeDuration) {
                return;
            }
            file.delete();
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File subFile : files) {
            FileUtil.deleteFile(subFile);
        }
        file.delete();
    }

    public static void deleteFile(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File subFile : files) {
            FileUtil.deleteFile(subFile);
        }
        file.delete();
    }

    public static void deleteFile(String filePath) {
        FileUtil.deleteFile(new File(filePath));
    }

    public static List<String> getFilePathsByFile(File file, FilenameFilter filter) {
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        if (file.isFile()) {
            return Arrays.asList(file.getPath());
        }
        if (null == filter) {
            return Arrays.asList(file.list());
        }
        return Arrays.asList(file.list(filter));
    }

    public static List<String> getFilePathsByFile(File file) {
        return FileUtil.getFilePathsByFile(file, null);
    }

    public static List<String> getFilePathsByFile(String filePath) {
        return FileUtil.getFilePathsByFile(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream inputStream, String encoding) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(inputStream, encoding));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            StreamUtil.close(br);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            StreamUtil.close(br);
        }
        return null;
    }

    public static String readString(String path) {
        return FileUtil.readString(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file) {
        if (null == file || !file.exists()) {
            return "";
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            StringBuilder stringBuffer = new StringBuilder((int)file.length());
            String temp = null;
            while ((temp = br.readLine()) != null) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(temp);
            }
            String string = stringBuffer.toString();
            StreamUtil.close(br);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            StreamUtil.close(br);
        }
        return "";
    }

    public static void writeString(String dest, String data) throws IOException {
        FileUtil.writeString(new File(dest), data);
    }

    public static void writeString(File dest, String data) throws IOException {
        FileUtil.outString(dest, data, null, false);
    }

    public static void appendString(File dest, String data) throws IOException {
        FileUtil.outString(dest, data, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outString(File dest, String data, String encoding, boolean append) throws IOException {
        if (null == dest || dest.exists() && dest.isDirectory()) {
            throw new IOException("\u590d\u5236\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest, append);
            out.write(null == encoding ? data.getBytes() : data.getBytes(encoding));
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(out);
    }

    public static void writeObject(String dest, Object object) throws IOException {
        FileUtil.writeObject(new File(dest), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(File dest, Object object) throws IOException {
        if (null == dest || dest.exists() && dest.isDirectory()) {
            throw new IOException("\u590d\u5236\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
        }
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(dest));
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
        }
        catch (Throwable throwable) {
            StreamUtil.close(oos);
            StreamUtil.close(bos);
            throw throwable;
        }
        StreamUtil.close(oos);
        StreamUtil.close(bos);
    }

    public static <T> T readObject(String source) throws IOException {
        return FileUtil.readObject(new File(source));
    }

    public static <T> T readObject(File source) throws IOException {
        Object result = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(source));
            ois = new ObjectInputStream(bis);
            result = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                e.printStackTrace();
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.close(ois);
                StreamUtil.close(bis);
                throw throwable;
            }
        }
        StreamUtil.close(ois);
        StreamUtil.close(bis);
        return (T)result;
    }

    public static void checkFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static boolean exist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return new File(path).exists();
    }

    public static File getCacheDirectory(Context context) {
        File appCacheDir = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            appCacheDir = FileUtil.getExternalCacheDir(context);
        }
        if (appCacheDir == null) {
            appCacheDir = context.getCacheDir();
        }
        if (appCacheDir == null) {
            appCacheDir = context.getCacheDir();
        }
        return appCacheDir;
    }

    private static File getExternalCacheDir(Context context) {
        File dataDir = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File appCacheDir = new File(new File(dataDir, context.getPackageName()), "cache");
        if (!appCacheDir.exists()) {
            if (!appCacheDir.mkdirs()) {
                return null;
            }
            try {
                new File(appCacheDir, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return appCacheDir;
    }

    public static String FormetFileSize(long fileS) {
        if (fileS == 0L) {
            return "0.00B";
        }
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "K" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "M" : df.format((double)fileS / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static long getFileCount(File f) {
        long size = 0L;
        File[] fileList = f.listFiles();
        size = fileList.length;
        for (File file : fileList) {
            if (!file.isDirectory()) continue;
            size += FileUtil.getFileCount(file);
            --size;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        block7: {
            if (null == src || null == dest) {
                return;
            }
            if (!src.exists() || dest.isDirectory()) {
                throw new IOException("\u590d\u5236\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
            }
            FileInputStream input = null;
            FileOutputStream output = null;
            try {
                input = new FileInputStream(src);
                output = new FileOutputStream(dest);
                StreamUtil.copy(input, output);
                StreamUtil.close(output);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                StreamUtil.close(output);
                StreamUtil.close(input);
            }
            StreamUtil.close(input);
        }
    }

    public static void copyDir(String sourceDir, String targetDir) throws IOException {
        new File(targetDir).mkdirs();
        File[] file = new File(sourceDir).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                File sourceFile = file[i];
                File targetFile = new File(new File(targetDir).getAbsolutePath() + File.separator + file[i].getName());
                FileUtil.copyFile(sourceFile, targetFile);
            }
            if (!file[i].isDirectory()) continue;
            String dir1 = sourceDir + file[i].getName();
            String dir2 = targetDir + "/" + file[i].getName();
            FileUtil.copyDir(dir1, dir2);
        }
    }

    public static File copyFileToDir(File src, File destDir) throws IOException {
        if (null == src || null == destDir) {
            return null;
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IOException("\u590d\u5236\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
        }
        File dest = new File(destDir, src.getName());
        FileUtil.copyFile(src, dest);
        return dest;
    }

    public static String getChoosedPicturePath(Uri uri, Activity activity) {
        String imagePath = "";
        if (null == uri) {
            return "";
        }
        if (uri.toString().startsWith("content://")) {
            String[] projection = new String[]{"_data"};
            Cursor cursor = activity.managedQuery(uri, projection, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            imagePath = cursor.getString(column_index);
        } else {
            imagePath = uri.toString().startsWith("file://") ? uri.toString().substring("file://".length()) : uri.toString();
        }
        String path = null;
        if (TextUtils.isEmpty((CharSequence)imagePath)) {
            return null;
        }
        String tempPath = imagePath.toLowerCase();
        if (tempPath.endsWith(".jpg") || tempPath.endsWith(".png") || tempPath.endsWith(".jpeg")) {
            path = imagePath;
        }
        return path;
    }

    public static File compressFile(Context context, String filepath, int rotato) {
        File file;
        File PHOTO_DIR = new File(Environment.getExternalStorageDirectory() + "/DCIM/photo");
        if (!PHOTO_DIR.exists()) {
            PHOTO_DIR.mkdirs();
        }
        if ((file = new File(PHOTO_DIR, System.currentTimeMillis() + ".jpg")).exists()) {
            file.delete();
        }
        try {
            ExifInterface eff = new ExifInterface(filepath);
            int dree = eff.getAttributeInt("Orientation", 1);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            Bitmap photo = BitmapFactory.decodeFile((String)filepath, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            float reqHeight = 1280.0f;
            float reqWidth = 720.0f;
            int height = options.outHeight;
            int width = options.outWidth;
            int inSampleSize = 1;
            if ((float)height > reqHeight || (float)width > reqWidth) {
                int widthRatio;
                int heightRatio = Math.round((float)height / reqHeight);
                int n = inSampleSize = heightRatio > (widthRatio = Math.round((float)width / reqWidth)) ? heightRatio : widthRatio;
            }
            if (inSampleSize < 1) {
                inSampleSize = 1;
            }
            options.inSampleSize = inSampleSize;
            photo = BitmapFactory.decodeFile((String)filepath, (BitmapFactory.Options)options);
            Matrix matrix1 = new Matrix();
            if (rotato != -1) {
                matrix1.setRotate((float)rotato);
            } else {
                matrix1.setRotate((float)FileUtil.readPictureDegree(filepath));
            }
            Bitmap b = Bitmap.createBitmap((Bitmap)photo, (int)0, (int)0, (int)photo.getWidth(), (int)photo.getHeight(), (Matrix)matrix1, (boolean)true);
            FileOutputStream fos = null;
            fos = new FileOutputStream(file.getPath());
            b.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
            photo.recycle();
            b.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBitmap(Bitmap bitmap, String file) {
        if (bitmap != null) {
            File f = new File(file);
            if (f.exists()) {
                return;
            }
            FileOutputStream fOut = null;
            try {
                fOut = new FileOutputStream(f);
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
                fOut.flush();
                bitmap.recycle();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtil.close(fOut);
                    throw throwable;
                }
                StreamUtil.close(fOut);
            }
            StreamUtil.close(fOut);
        }
    }

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtil.delAllFile(path + "/" + tempList[i]);
            FileUtil.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public static String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getRawDataFromFile(String modelPath) {
        byte[] model = null;
        FileInputStream fp = null;
        try {
            fp = new FileInputStream(modelPath);
            int fileSize = fp.available();
            model = new byte[fileSize];
            fp.read(model);
            fp.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fp != null) {
                    fp.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return model;
    }

    static {
        if (!new File(FILE_CACHE_PATH).exists()) {
            new File(FILE_CACHE_PATH).mkdirs();
        }
        if (!new File(FILE_TEMP_PATH).exists()) {
            new File(FILE_TEMP_PATH).mkdirs();
        }
        if (!new File(FILE_INSTALL_PATH).exists()) {
            new File(FILE_INSTALL_PATH).mkdirs();
        }
        if (!new File(FILE_LOG_PATH).exists()) {
            new File(FILE_LOG_PATH).mkdirs();
        }
    }

    public static class ZipUtil {
        public static final String EXT = ".zip";
        private static final String BASE_DIR = "";
        private static final String PATH = File.separator;
        private static final int BUFFER = 1024;

        public static void decompress(String srcPath) throws Exception {
            File srcFile = new File(srcPath);
            ZipUtil.decompress(srcFile);
        }

        public static void decompress(File srcFile) throws Exception {
            String basePath = srcFile.getParent();
            ZipUtil.decompress(srcFile, basePath);
        }

        public static void decompress(File srcFile, File destFile) throws Exception {
            ZipUtil.decompress(new FileInputStream(srcFile), destFile);
        }

        public static void decompress(InputStream srcInputStream, File destFile) throws Exception {
            CheckedInputStream cis = new CheckedInputStream(srcInputStream, new CRC32());
            ZipInputStream zis = new ZipInputStream(cis);
            ZipUtil.decompress(destFile, zis);
            zis.close();
        }

        public static void decompress(File srcFile, String destPath) throws Exception {
            ZipUtil.decompress(srcFile, new File(destPath));
        }

        public static void decompress(String srcPath, String destPath) throws Exception {
            File srcFile = new File(srcPath);
            ZipUtil.decompress(srcFile, destPath);
        }

        private static void decompress(File destFile, ZipInputStream zis) throws Exception {
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                String dir = destFile.getPath() + File.separator + entry.getName();
                File dirFile = new File(dir);
                ZipUtil.fileProber(dirFile);
                if (entry.isDirectory()) {
                    dirFile.mkdirs();
                } else {
                    ZipUtil.decompressFile(dirFile, zis);
                }
                zis.closeEntry();
            }
        }

        private static void fileProber(File dirFile) {
            File parentFile = dirFile.getParentFile();
            if (!parentFile.exists()) {
                ZipUtil.fileProber(parentFile);
                parentFile.mkdir();
            }
        }

        private static void decompressFile(File destFile, ZipInputStream zis) throws Exception {
            int count;
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
            byte[] data = new byte[1024];
            while ((count = zis.read(data, 0, 1024)) != -1) {
                bos.write(data, 0, count);
            }
            bos.close();
        }
    }

    public static class StreamUtil {
        private static int ioBufferSize = 1024;

        public static void close(InputStream in) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public static void close(OutputStream out) {
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public static void close(Reader in) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public static void close(Writer out) {
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public static int copy(InputStream input, OutputStream output) throws IOException {
            int read;
            byte[] buffer = new byte[ioBufferSize];
            int count = 0;
            while ((read = input.read(buffer, 0, ioBufferSize)) != -1) {
                output.write(buffer, 0, read);
                count += read;
            }
            return count;
        }

        public static int copy(Reader input, Writer output) throws IOException {
            int read;
            char[] buffer = new char[ioBufferSize];
            int count = 0;
            while ((read = input.read(buffer, 0, ioBufferSize)) >= 0) {
                output.write(buffer, 0, read);
                count += read;
            }
            output.flush();
            return count;
        }
    }
}

