/*
 * Decompiled with CFR 0.152.
 */
package com.momocv;

import android.os.Build;
import com.momocv.ClientInfo;
import com.momocv.GpuUtils;
import com.momocv.OsUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;

public class ApiBase
implements Serializable {
    public static boolean SetEventTrackingCallBack(OnEventTrackingListener callback) {
        return ApiBase.nativeSetEventTrackingCallBack(callback);
    }

    public static void SetEventTrackingEnable() {
        ApiBase.nativeSetEventTrackingEnable();
    }

    public static void InitEnvironment() {
        ClientInfo client_info = new ClientInfo();
        client_info.cpu_type_ = ApiBase.getCpuModel();
        client_info.gpu_type_ = GpuUtils.getGpuInfo();
        ApiBase.nativeSetClientInfo(client_info);
    }

    public static void SetEventTrackingDisable() {
        ApiBase.nativeSetEventTrackingDisable();
    }

    public static String getCpuModel() {
        String str1 = "/proc/cpuinfo";
        String str2 = "";
        try {
            FileReader fr = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(fr);
            while ((str2 = localBufferedReader.readLine()) != null) {
                if (!str2.contains("Hardware")) continue;
                localBufferedReader.close();
                return str2.split(":")[1].trim();
            }
            localBufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Build.HARDWARE;
    }

    private static native boolean nativeSetEventTrackingCallBack(OnEventTrackingListener var0);

    private static native void nativeSetClientInfo(ClientInfo var0);

    private static native void nativeSetEventTrackingEnable();

    private static native void nativeSetEventTrackingDisable();

    static {
        if (OsUtils.isWindows()) {
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
        } else {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("mmcv_base");
            System.loadLibrary("mmcv_api_base");
        }
    }

    public static interface OnEventTrackingListener {
        public void onEventTrackingCallBack(String var1);
    }
}

