/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.moment.render;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import com.core.glcore.config.MRConfig;
import com.core.glcore.config.MRCoreParameters;
import com.core.glcore.config.Size;
import com.core.glcore.util.Log4Cam;
import java.util.LinkedList;
import java.util.Queue;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.ext.GLProcessingPipeline;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.colour.NormalFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class BasicRender {
    private static final String TAG = "MomoRender";
    protected GLProcessingPipeline pipeline;
    private int mTextureID = -12345;
    private SurfaceTexture mSurfaceTexture;
    BasicFilter selectFilter;
    protected GLTextureOutputRenderer mRootRender = null;
    protected NormalFilter mTailRender = null;
    private int previewWidth = 352;
    private int previewHeight = 640;
    final Queue<Runnable> mRunOnDraw;
    final Queue<Runnable> mRunOnDrawEnd;
    protected MRCoreParameters mrCoreParameters = null;
    a onSurfaceChangedListener = null;

    public BasicRender(MRCoreParameters mrCoreParameters) {
        this.mrCoreParameters = mrCoreParameters;
        if (null != mrCoreParameters) {
            this.previewWidth = mrCoreParameters.previewVideoWidth;
            this.previewHeight = mrCoreParameters.previewVideoHeight;
        }
        this.mRunOnDraw = new LinkedList<Runnable>();
        this.mRunOnDrawEnd = new LinkedList<Runnable>();
    }

    public boolean prepare(MRConfig mrConfig, BasicFilter filter) {
        this.initPipline(filter);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        Queue<Runnable> queue = this.mRunOnDraw;
        synchronized (queue) {
            this.mRunOnDraw.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDrawEnd(Runnable runnable) {
        Queue<Runnable> queue = this.mRunOnDrawEnd;
        synchronized (queue) {
            this.mRunOnDrawEnd.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAll(Queue<Runnable> queue) {
        Queue<Runnable> queue2 = queue;
        synchronized (queue2) {
            while (!queue.isEmpty()) {
                queue.poll().run();
            }
        }
    }

    private void initPipline(BasicFilter glRenderer) {
        GLProcessingPipeline gLProcessingPipeline;
        this.pipeline = gLProcessingPipeline = new GLProcessingPipeline();
        gLProcessingPipeline.changeSize(this.previewWidth, this.previewHeight);
        this.initInternalFilter();
        if (glRenderer != null) {
            this.selectFilter = glRenderer;
            this.mRootRender.addTarget((GLTextureInputRenderer)this.selectFilter);
            this.selectFilter.addTarget((GLTextureInputRenderer)this.mTailRender);
        } else {
            this.mRootRender.addTarget((GLTextureInputRenderer)this.mTailRender);
        }
        gLProcessingPipeline.addRootRenderer((GLRenderer)this.mRootRender);
        gLProcessingPipeline.startRendering();
    }

    public void addFilterToDestroy(BasicFilter basicFilter) {
        if (null != this.pipeline) {
            this.pipeline.addFilterToDestroy((GLRenderer)basicFilter);
        }
    }

    public int getTextureId() {
        return this.mTextureID;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    public void selectFilter(BasicFilter filter) {
        if (filter == null || filter == this.selectFilter || this.mRootRender == null) {
            return;
        }
        if (null != this.selectFilter) {
            this.selectFilter.clearTarget();
            this.pipeline.addFilterToDestroy((GLRenderer)this.selectFilter);
        }
        this.selectFilter = filter;
        this.mRootRender.clearTarget();
        if (this.selectFilter == null) {
            this.mRootRender.addTarget((GLTextureInputRenderer)this.mTailRender);
        } else {
            this.mRootRender.addTarget((GLTextureInputRenderer)this.selectFilter);
            this.selectFilter.addTarget((GLTextureInputRenderer)this.mTailRender);
        }
    }

    public void drawCodecFrame() {
        this.runAll(this.mRunOnDraw);
        this.drawDataToCodec();
    }

    public void drawFrame(int FrameBufferID) {
        this.runAll(this.mRunOnDraw);
        this.drawDataToDispalay();
        GLES20.glFinish();
        this.runAll(this.mRunOnDrawEnd);
    }

    public SurfaceTexture createTexture() {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        this.mTextureID = nArray[0];
        GLES20.glBindTexture((int)36197, (int)this.mTextureID);
        this.checkGlError("glBindTexture mTextureID");
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        this.checkGlError("glTexParameter");
        this.mSurfaceTexture = new SurfaceTexture(this.mTextureID);
        return this.mSurfaceTexture;
    }

    public void surfaceCreated() {
        this.mSurfaceTexture = this.createTexture();
    }

    public void release() {
        try {
            if (this.mSurfaceTexture != null) {
                this.mSurfaceTexture.release();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mSurfaceTexture = null;
        if (null != this.pipeline) {
            this.pipeline.destroy();
            this.pipeline = null;
        }
        if (null != this.selectFilter) {
            this.selectFilter.destroy();
            this.selectFilter = null;
        }
        if (null != this.mTailRender) {
            this.mTailRender.destroy();
            this.mTailRender = null;
        }
        if (null != this.mRunOnDraw) {
            this.mRunOnDraw.clear();
        }
        if (null != this.mRunOnDrawEnd) {
            this.mRunOnDrawEnd.clear();
        }
    }

    public void checkGlError(String op) {
        int n2;
        while ((n2 = GLES20.glGetError()) != 0) {
            Log4Cam.e((String)TAG, (String)(op + ": glError " + n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRenderSize(final Size size, final boolean isFront, final int rotateValue) {
        Queue<Runnable> queue = this.mRunOnDraw;
        synchronized (queue) {
            this.mRunOnDraw.clear();
        }
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                if (BasicRender.this.onSurfaceChangedListener != null) {
                    BasicRender.this.onSurfaceChangedListener.a();
                }
                BasicRender.this.updateSize(size, isFront, rotateValue);
            }
        });
    }

    void updateSize(Size size, boolean isFront, int rotateValue) {
    }

    protected void drawDataToDispalay() {
    }

    protected void drawDataToCodec() {
    }

    protected void initInternalFilter() {
    }

    public void setTimeStamp(long ptsMs) {
        if (this.selectFilter instanceof IVideoTrackTime) {
            ((IVideoTrackTime)this.selectFilter).setTimeStamp(ptsMs);
        }
    }

    public void setOnSurfaceChangedListener(a listener) {
        this.onSurfaceChangedListener = listener;
    }

    public static interface a {
        public void a();
    }
}

