/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.moment.mediautils;

import com.core.glcore.util.Log4Cam;
import com.immomo.moment.mediautils.z;
import java.nio.ByteBuffer;

public class AudioResampleUtils
extends z {
    private long mPointer = 0L;
    private long mScalePointrer = 0L;
    private ByteBuffer mResultBufer = null;
    int mDstSamplerate = 0;
    int mDstSampleBits = 0;
    int mDstSampleChannels = 0;
    private ByteBuffer mTempBuffer;
    Object mSync = new Object();

    private native long nativeCreateNewSampler(int var1, int var2, int var3, int var4, int var5, int var6);

    private native int nativeResamplePcmData(long var1, byte[] var3, int var4, byte[] var5);

    private native void nativeRelease(long var1);

    private native long nativeCreateNewScaler(int var1, int var2, int var3);

    private native int nativeScalePcmData(long var1, byte[] var3, int var4, float var5, byte[] var6);

    private native void nativeReleaseScale(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initResampleInfo(int srcSampleRate, int srcChannels, int srcSampleBits, int dstSampleRate, int dstChannels, int dstSampleBits) {
        Object object = this.mSync;
        synchronized (object) {
            this.mDstSamplerate = dstSampleRate;
            this.mDstSampleBits = dstSampleBits;
            this.mDstSampleChannels = dstChannels;
            this.mPointer = this.nativeCreateNewSampler(srcSampleRate, srcChannels, srcSampleBits, dstSampleRate, dstChannels, dstSampleBits);
            if (this.mPointer == 0L) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resamplePcmData(byte[] src, int samples, byte[] dst) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPointer != 0L) {
                return this.nativeResamplePcmData(this.mPointer, src, samples, dst);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer resamplePcmData(byte[] src, int srcSize) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPointer != 0L) {
                int n2 = 0;
                int n3 = 8 * srcSize * this.mDstSampleChannels * this.mDstSampleBits / 8;
                if (this.mResultBufer == null || this.mResultBufer.capacity() != n3) {
                    this.mResultBufer = ByteBuffer.allocate(n3);
                }
                this.mResultBufer.position(0);
                n2 = this.nativeResamplePcmData(this.mPointer, src, srcSize, this.mResultBufer.array());
                if (n2 > 0) {
                    int n4 = n2 * this.mDstSampleBits * this.mDstSampleChannels / 8;
                    ByteBuffer byteBuffer = ByteBuffer.allocate(n4);
                    this.mResultBufer.position(0);
                    this.mResultBufer.get(byteBuffer.array());
                    byteBuffer.position(0);
                    return byteBuffer;
                }
                return null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPointer != 0L) {
                this.nativeRelease(this.mPointer);
                this.mPointer = 0L;
            }
            if (this.mScalePointrer != 0L) {
                this.nativeReleaseScale(this.mScalePointrer);
            }
        }
    }

    public int initScaleInfo(int sampleRate, int channels, int bits) {
        this.mScalePointrer = this.nativeCreateNewScaler(sampleRate, channels, bits);
        if (this.mScalePointrer == 0L) {
            return -1;
        }
        return 0;
    }

    public int scalePcmData(ByteBuffer src, int size, float ratio, ByteBuffer dst) {
        if (this.mScalePointrer != 0L) {
            if (this.mTempBuffer == null || this.mTempBuffer.capacity() < size) {
                this.mTempBuffer = ByteBuffer.allocate(size);
            }
            ByteBuffer byteBuffer = this.mTempBuffer;
            src.position(0);
            byteBuffer.position(0);
            src.get(byteBuffer.array(), 0, size);
            byteBuffer.position(0);
            src.position(0);
            int n2 = this.nativeScalePcmData(this.mScalePointrer, byteBuffer.array(), size, ratio, dst.array());
            Log4Cam.e((String)"AudioResamplesUtils", (String)("ret value is " + n2));
            return n2;
        }
        return -1;
    }
}

