/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil.toast;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;
import com.mm.mmutil.app.AppContext;
import com.mm.mmutil.log.Log4Android;
import com.mm.mmutil.toast.MToaster;

public class Toaster {
    private static final int MSG_SHOW_D = 1365;
    private static final int MSG_SHOW_INVALIDATE = 1366;
    private static final int MSG_SHOW_INVALIDATE_D = 1367;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_DURATION = 0;
    public static final int LENGTH_LONG = 1;
    public static final int LENGTH_SHORT = 0;
    protected Toast toast = null;
    private static Context context = null;
    private static Toaster showner = null;
    private static Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            if (msg.what == 1365) {
                Toaster.doShow((CharSequence)msg.obj, msg.arg1);
            } else if (msg.what == 1366) {
                Toaster.doShowInvalidate((CharSequence)msg.obj);
            } else if (msg.what == 1367) {
                Toaster.doShowInvalidate((CharSequence)msg.obj, msg.arg1);
            }
        }
    };

    protected Toaster() {
        if (context == null) {
            throw new RuntimeException("Showner not been activated. You must call 'doEnable(Context c)' method before");
        }
        this.makeNewToast();
    }

    public static void reset() {
        showner = null;
    }

    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.toast.setGravity(gravity, xOffset, yOffset);
    }

    public void showMsg(CharSequence msg) {
        this.showMsg(msg, false);
    }

    public void showMsg(Object msg) {
        this.showMsg(msg.toString());
    }

    public void showMsg(int resId) {
        this.showMsg(context.getString(resId));
    }

    public void showMsg(CharSequence msg, boolean makeNew) {
        this.showMsg(msg, false, 0);
    }

    public void showMsg(CharSequence msg, boolean makeNew, int duration) {
        try {
            if (makeNew) {
                this.makeNewToast();
            }
            this.toast.setText(msg);
            this.toast.setDuration(duration);
            this.toast.show();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getDuration() {
        return this.toast.getDuration();
    }

    public void setDuration(int duration) {
        this.toast.setDuration(duration);
    }

    public void setView(View view) {
        this.toast.setView(view);
    }

    public static void show(Object obj, int duration) {
        Toaster.show(obj.toString(), duration);
    }

    public static void show(int resId, int duration) {
        Toaster.show(context.getString(resId), duration);
    }

    public static void show(Object text) {
        Toaster.show(text, 0);
    }

    public static void show(CharSequence text) {
        Toaster.show(text, 0);
    }

    public static void debug(CharSequence text) {
    }

    public static void show(CharSequence text, int duration) {
        if (!AppContext.isAppOnForeground()) {
            return;
        }
        if (AppContext.isRunningInMainThread()) {
            Toaster.doShow(text, duration);
        } else {
            Message msg = Message.obtain();
            msg.what = 1365;
            msg.obj = text;
            msg.arg1 = duration;
            handler.sendMessage(msg);
        }
    }

    public static void show(int resId) {
        String msg = context.getString(resId);
        Toaster.show(msg);
    }

    public static void changeView(View view) {
        showner.setView(view);
    }

    protected void makeNewToast() {
        this.toast = Toast.makeText((Context)context, (CharSequence)"", (int)0);
    }

    public static void doEnable(Context context) {
        Toaster.context = context;
    }

    public static void showInvalidate(CharSequence message) {
        if (!AppContext.isAppOnForeground()) {
            return;
        }
        if (AppContext.isRunningInMainThread()) {
            Toaster.doShowInvalidate(message);
        } else {
            Message msg = new Message();
            msg.what = 1366;
            msg.obj = message;
            handler.sendMessage(msg);
        }
    }

    public static void showInvalidate(CharSequence message, int duration) {
        if (!AppContext.isAppOnForeground()) {
            return;
        }
        if (AppContext.isRunningInMainThread()) {
            Toaster.doShowInvalidate(message, duration);
        } else {
            Message msg = new Message();
            msg.what = 1367;
            msg.obj = message;
            msg.arg1 = duration;
            handler.sendMessage(msg);
        }
    }

    public static void showInvalidate(int resId, int duration) {
        String str = context.getString(resId);
        Toaster.showInvalidate(str, duration);
    }

    public static void debugInvalidate(CharSequence message) {
    }

    public static void showInvalidate(int resId) {
        String str = context.getString(resId);
        Toaster.showInvalidate(str);
    }

    private static void doShow(CharSequence text, int duration) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        try {
            if (showner == null) {
                showner = MToaster.getInstance();
            }
            int d = showner.getDuration();
            showner.showMsg(text, false, duration);
            showner.setDuration(d);
        }
        catch (Throwable e) {
            Log4Android.getInstance().e(e);
        }
    }

    private static void doShowInvalidate(CharSequence str) {
        if (showner == null) {
            showner = MToaster.getInstance();
        }
        showner.showMsg(str);
    }

    private static void doShowInvalidate(CharSequence str, int dur) {
        if (showner == null) {
            showner = MToaster.getInstance();
        }
        int d = showner.getDuration();
        showner.showMsg(str, false, dur);
        showner.setDuration(d);
    }
}

