/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil.objectpool;

import com.mm.mmutil.log.Log4Android;
import com.mm.mmutil.objectpool.ObjectFactory;
import com.mm.mmutil.objectpool.ObjectPool;
import com.mm.mmutil.objectpool.PoolConfig;
import com.mm.mmutil.objectpool.Poolable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class ObjectPoolWorker<T extends Poolable> {
    private final ObjectPool<T> pool;
    private final PoolConfig config;
    private final BlockingQueue<T> objectQueue;
    private final ObjectFactory<T> objectFactory;
    private int totalCount;

    public ObjectPoolWorker(ObjectPool<T> pool, PoolConfig config, ObjectFactory<T> objectFactory) throws InterruptedException {
        this.pool = pool;
        this.config = config;
        this.objectFactory = objectFactory;
        this.objectQueue = new ArrayBlockingQueue<T>(config.getMaxSize());
        for (int i = 0; i < config.getMinSize(); ++i) {
            this.objectQueue.put(objectFactory.create());
        }
        this.totalCount = config.getMinSize();
    }

    public BlockingQueue<T> getObjectQueue() {
        return this.objectQueue;
    }

    public synchronized int increaseObjects(int delta) {
        if (delta + this.totalCount > this.config.getMaxSize()) {
            delta = this.config.getMaxSize() - this.totalCount;
        }
        try {
            for (int i = 0; i < delta; ++i) {
                this.objectQueue.put(this.objectFactory.create());
            }
            this.totalCount += delta;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return delta;
    }

    public synchronized boolean decreaseObject(T obj) {
        this.objectFactory.destroy(obj);
        --this.totalCount;
        return true;
    }

    public synchronized int getTotalCount() {
        return this.totalCount;
    }

    public synchronized void scavenge() throws InterruptedException {
        Poolable obj;
        int delta = this.totalCount - this.config.getMinSize();
        if (delta <= 0) {
            return;
        }
        int removed = 0;
        long now = System.currentTimeMillis();
        Log4Android.getInstance().i("duanqing ObjectPool \u95f2\u7f6e\u5bf9\u8c61\u5b9a\u671f\u68c0\u67e5");
        while (delta-- > 0 && (obj = (Poolable)this.objectQueue.poll()) != null) {
            if (now - obj.getLastAccessTs() > (long)this.config.getMaxIdleMilliseconds()) {
                Log4Android.getInstance().i("duanqing ObjectPool \u5bf9\u8c61\u5904\u4e8e\u95f2\u7f6e\u72b6\u6001\uff0cdestroy it");
                this.decreaseObject(obj);
                ++removed;
                continue;
            }
            this.objectQueue.put(obj);
        }
    }

    public synchronized int shutdown() {
        int removed = 0;
        while (this.totalCount > 0) {
            Poolable obj = (Poolable)this.objectQueue.poll();
            if (obj == null) continue;
            this.decreaseObject(obj);
            ++removed;
        }
        return removed;
    }
}

