/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil.objectpool;

import com.mm.mmutil.objectpool.ObjectFactory;
import com.mm.mmutil.objectpool.ObjectPoolWorker;
import com.mm.mmutil.objectpool.PoolConfig;
import com.mm.mmutil.objectpool.Poolable;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ObjectPool<T extends Poolable> {
    protected final PoolConfig config;
    protected final ObjectFactory<T> factory;
    protected final ObjectPoolWorker<T> poolWorker;
    private Scavenger scavenger;
    private volatile boolean shuttingDown;

    public ObjectPool(PoolConfig poolConfig, ObjectFactory<T> objectFactory) {
        this.config = poolConfig;
        this.factory = objectFactory;
        try {
            this.poolWorker = new ObjectPoolWorker<T>(this, this.config, objectFactory);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.config.getScavengeIntervalMilliseconds() > 0) {
            this.scavenger = new Scavenger();
            this.scavenger.start();
        }
    }

    public T borrowObject() {
        return this.borrowObject(true);
    }

    public T borrowObject(boolean blocking) {
        for (int i = 0; i < 3; ++i) {
            T result = this.getObject(blocking);
            if (this.factory.validate(result)) {
                return result;
            }
            this.poolWorker.decreaseObject(result);
        }
        throw new RuntimeException("Cannot find a valid object");
    }

    private T getObject(boolean blocking) {
        if (this.shuttingDown) {
            throw new IllegalStateException("Your pool is shutting down");
        }
        Poolable freeObject = (Poolable)this.poolWorker.getObjectQueue().poll();
        if (freeObject == null) {
            this.poolWorker.increaseObjects(1);
            try {
                if (blocking) {
                    freeObject = (Poolable)this.poolWorker.getObjectQueue().take();
                } else {
                    freeObject = (Poolable)this.poolWorker.getObjectQueue().poll(this.config.getMaxWaitMilliseconds(), TimeUnit.MILLISECONDS);
                    if (freeObject == null) {
                        throw new RuntimeException("Cannot get a free object from the pool");
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        freeObject.setLastAccessTs(System.currentTimeMillis());
        return (T)freeObject;
    }

    public void returnObject(T obj) {
        try {
            obj.reset();
            this.poolWorker.getObjectQueue().put(obj);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void returnObject(List<T> objs) {
        try {
            for (Poolable t : objs) {
                t.reset();
                this.poolWorker.getObjectQueue().put(t);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getSize() {
        return this.poolWorker.getTotalCount();
    }

    public synchronized int shutdown() throws InterruptedException {
        this.shuttingDown = true;
        int removed = 0;
        if (this.scavenger != null) {
            this.scavenger.interrupt();
            this.scavenger.join();
        }
        return removed += this.poolWorker.shutdown();
    }

    private class Scavenger
    extends Thread {
        private Scavenger() {
        }

        @Override
        public void run() {
            while (!ObjectPool.this.shuttingDown) {
                try {
                    Thread.sleep(ObjectPool.this.config.getScavengeIntervalMilliseconds());
                    ObjectPool.this.poolWorker.scavenge();
                }
                catch (Exception exception) {}
            }
        }
    }
}

