/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;

public class StringUtils {
    private static final int HOURS_OF_DAY = 24;
    private static final int MINUTES_OF_HOUR = 60;
    private static final int SECONDS_OF_MINUTE = 60;
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] APOS_ENCODE = "&apos;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();

    public static boolean notEmpty(CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String[] str2Arr(String value, String tag) {
        if (!StringUtils.isEmpty(value)) {
            return value.split(tag);
        }
        return null;
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, "", 0, array.length);
    }

    public static String join(String separator, String ... array) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, "", 0, array.length);
    }

    public static String join(Object[] array, String ch, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, ch, 0, array.length);
    }

    public static String join(Object[] array, String separator, String ch, int startIndex, int endIndex) {
        int bufSize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((bufSize = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + separator.length());
        for (int i = startIndex; i < endIndex; ++i) {
            if (array[i] == null) continue;
            if (i > startIndex) {
                buf.append(separator);
            }
            buf.append(ch).append(array[i]).append(ch);
        }
        return buf.toString();
    }

    public static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), separator);
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            if (first != null) {
                return first.toString();
            }
            return "";
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String Conll2StringWithSingleGuotes(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            if (first != null) {
                return "'" + first.toString() + "'";
            }
            return "";
        }
        StringBuffer buf = new StringBuffer(256);
        if (first != null) {
            buf.append("'" + first + "'");
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append("'" + obj + "'");
        }
        return buf.toString();
    }

    public static String escapeUnicode(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescapeUnicode(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    private static long CalPassedDay(long totalSec) {
        long result = totalSec / 86400L;
        return result;
    }

    private static long CalPassedHour(long totalSec) {
        long result = totalSec % 86400L / 3600L;
        return result;
    }

    private static long CalPassedMin(long totalSec) {
        long result = totalSec % 86400L % 3600L / 60L;
        return result;
    }

    private static long CalPassedSec(long totalSec) {
        long result = totalSec % 86400L % 3600L % 60L;
        return result;
    }

    public static String TimeStampToTime(long creat_stmap, long server_stamp) {
        String result = "";
        long passedTotalSeconds = server_stamp - creat_stmap;
        if (passedTotalSeconds <= 0L) {
            result = "1\u79d2\u949f\u524d";
            return result;
        }
        long passedDay = StringUtils.CalPassedDay(passedTotalSeconds);
        long passedHour = StringUtils.CalPassedHour(passedTotalSeconds);
        long passedMin = StringUtils.CalPassedMin(passedTotalSeconds);
        long passedSec = StringUtils.CalPassedSec(passedTotalSeconds);
        if (passedDay > 0L) {
            result = new Long(passedDay).toString() + "\u5929\u524d";
            return result;
        }
        if (passedHour > 0L) {
            result = new Long(passedHour).toString() + "\u5c0f\u65f6\u524d";
            return result;
        }
        if (passedMin > 0L) {
            result = new Long(passedMin).toString() + "\u5206\u949f\u524d";
            return result;
        }
        if (passedSec > 0L) {
            result = new Long(passedSec).toString() + "\u79d2\u524d";
            return result;
        }
        return result;
    }

    public static String md5(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String h = Integer.toHexString(0xFF & messageDigest[i]);
                while (h.length() < 2) {
                    h = "0" + h;
                }
                hexString.append(h);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return s;
        }
    }

    public static boolean contains(String str1, String str2) {
        return str1.contains(str2) || str2.contains(str1);
    }

    public static boolean startsWith(String str1, String str2) {
        return str1.startsWith(str2) || str2.startsWith(str1);
    }

    public static String escapeForXML(String string) {
        int i;
        if (string == null) {
            return null;
        }
        int last = 0;
        char[] input = string.toCharArray();
        int len = input.length;
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch == '>') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(GT_ENCODE);
                continue;
            }
            if (ch == '&') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                if (len > i + 5 && input[i + 1] == '#' && Character.isDigit(input[i + 2]) && Character.isDigit(input[i + 3]) && Character.isDigit(input[i + 4]) && input[i + 5] == ';') continue;
                last = i + 1;
                out.append(AMP_ENCODE);
                continue;
            }
            if (ch == '\"') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(QUOTE_ENCODE);
                continue;
            }
            if (ch != '\'') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(APOS_ENCODE);
        }
        if (last == 0) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static String replaceAll(String str, String oldStr, String newStr) {
        int i = str.indexOf(oldStr);
        while (i != -1) {
            str = str.substring(0, i) + newStr + str.substring(i + oldStr.length());
            i = str.indexOf(oldStr, i + newStr.length());
        }
        return str;
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static byte[] hash256(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(str.getBytes());
            return md.digest();
        }
        catch (Exception e) {
            return null;
        }
    }
}

