/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil;

import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.mm.mmutil.app.AppContext;
import com.mm.mmutil.log.Log4Android;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetUtils {
    public static final String NETWORK_TYPE_WIFI = "wifi";
    public static final String NETWORK_TYPE_MOBILE = "mobile";
    public static final String NETWORK_CLASS_2G = "2g";
    public static final String NETWORK_CLASS_3G = "3g";
    public static final String NETWORK_CLASS_4G = "4g";
    public static final String NETWORK_CLASS_UNKNOWN = "unknown";
    public static final String CTWAP = "ctwap";
    public static final String CMWAP = "cmwap";
    public static final String WAP_3G = "3gwap";
    public static final String UNIWAP = "uniwap";
    public static final String WIFI = "uniwap";
    public static final int TYPE_NET_WORK_DISABLED = 0;
    public static final int WAP_TYPE_CM = 1;
    public static final int WAP_TYPE_3G = 2;
    public static final int WAP_TYPE_UNI = 3;
    public static final int WAP_TYPE_CT = 5;
    public static final int TYPE_OTHER_NET = 6;
    public static final int NETWORK_STATUS_UNKNOWN = -1;
    public static final int NETWORK_STATUS_WIFI = 1;
    public static final int NETWORK_STATUS_2G = 2;
    public static final int NETWORK_STATUS_3G = 3;
    public static final int NETWORK_STATUS_4G = 4;
    public static Uri PREFERRED_APN_URI = Uri.parse((String)"content://telephony/carriers/preferapn");

    public static int getNetWorkStatus() {
        ConnectivityManager connManager;
        NetworkInfo activeNetInfo;
        if (AppContext.sContext != null && (activeNetInfo = (connManager = (ConnectivityManager)AppContext.sContext.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            if (activeNetInfo.getType() == 1) {
                return 1;
            }
            if (activeNetInfo.getType() == 0) {
                return NetUtils.getNetWorkStatus(activeNetInfo.getSubtype());
            }
        }
        return -1;
    }

    private static int getNetWorkStatus(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 3;
            }
            case 13: {
                return 4;
            }
        }
        return -1;
    }

    public static String getNetWorkType() {
        ConnectivityManager connManager;
        NetworkInfo activeNetInfo;
        if (AppContext.sContext != null && (activeNetInfo = (connManager = (ConnectivityManager)AppContext.sContext.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            if (activeNetInfo.getType() == 1) {
                return NETWORK_TYPE_WIFI;
            }
            if (activeNetInfo.getType() == 0) {
                return NETWORK_TYPE_MOBILE;
            }
        }
        return null;
    }

    public static String getNetWorkClass() {
        try {
            ConnectivityManager connManager;
            NetworkInfo activeNetInfo;
            if (AppContext.sContext != null && (activeNetInfo = (connManager = (ConnectivityManager)AppContext.sContext.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
                if (activeNetInfo.getType() == 1) {
                    return NETWORK_TYPE_WIFI;
                }
                if (activeNetInfo.getType() == 0) {
                    return NetUtils.getNetworkClass(activeNetInfo.getSubtype());
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    private static String getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return NETWORK_CLASS_2G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return NETWORK_CLASS_3G;
            }
            case 13: {
                return NETWORK_CLASS_4G;
            }
        }
        return NETWORK_CLASS_UNKNOWN;
    }

    public static int getNetType() {
        if (AppContext.sContext != null) {
            try {
                ConnectivityManager connManager = (ConnectivityManager)AppContext.sContext.getSystemService("connectivity");
                NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
                if (activeNetInfo != null) {
                    return activeNetInfo.getType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getMobileNetType() {
        if (AppContext.sContext != null) {
            try {
                TelephonyManager manager = (TelephonyManager)AppContext.sContext.getSystemService("phone");
                return manager.getNetworkType();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean isWifi() {
        return NETWORK_TYPE_WIFI.equals(NetUtils.getNetWorkType());
    }

    public static boolean isMobile() {
        return NETWORK_TYPE_MOBILE.equals(NetUtils.getNetWorkType());
    }

    public static boolean is4G() {
        return NetUtils.getNetWorkStatus() == 4;
    }

    public static int getAPNPointType() {
        int type = -1;
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)AppContext.sContext.getSystemService("connectivity");
            NetworkInfo mobNetInfoActivity = connectivityManager.getActiveNetworkInfo();
            if (mobNetInfoActivity == null || !mobNetInfoActivity.isAvailable()) {
                type = 0;
            } else {
                int netType = mobNetInfoActivity.getType();
                if (netType == 1) {
                    type = 6;
                } else if (netType == 0) {
                    Cursor c = AppContext.sContext.getContentResolver().query(PREFERRED_APN_URI, null, null, null, null);
                    if (c != null) {
                        c.moveToFirst();
                        String user = c.getString(c.getColumnIndex("user"));
                        if (!TextUtils.isEmpty((CharSequence)user)) {
                            Log4Android.getInstance().i("=====================>\u4ee3\u7406\uff1a" + c.getString(c.getColumnIndex("proxy")));
                            if (user.startsWith(CTWAP)) {
                                Log4Android.getInstance().i("=====================>\u7535\u4fe1wap\u7f51\u7edc");
                                type = 5;
                            }
                        }
                        c.close();
                    }
                    String netMode = mobNetInfoActivity.getExtraInfo();
                    Log4Android.getInstance().i("netMode ================== " + netMode);
                    if (netMode != null) {
                        if ((netMode = netMode.toLowerCase()).equals(CMWAP)) {
                            type = 1;
                        } else if (netMode.equals(WAP_3G)) {
                            type = 2;
                        } else if (netMode.equals("uniwap")) {
                            type = 3;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            type = 6;
        }
        return type;
    }

    public static boolean isWap() {
        int apnType = NetUtils.getAPNPointType();
        return apnType == 2 || apnType == 1 || apnType == 5 || apnType == 3;
    }

    public static boolean isCMWAP() {
        String currentAPN = "";
        if (AppContext.sContext != null) {
            ConnectivityManager conManager = (ConnectivityManager)AppContext.sContext.getSystemService("connectivity");
            NetworkInfo info = conManager.getNetworkInfo(0);
            currentAPN = info.getExtraInfo();
            if (currentAPN == null || currentAPN == "") {
                return false;
            }
            return currentAPN.toLowerCase().equals(CMWAP);
        }
        return false;
    }

    public static boolean isWifiOpen() {
        if (AppContext.sContext == null) {
            return false;
        }
        WifiManager mWifiManager = (WifiManager)AppContext.sContext.getSystemService(NETWORK_TYPE_WIFI);
        return mWifiManager != null && mWifiManager.isWifiEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNetworkAvailable() {
        if (AppContext.sContext == null) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)AppContext.sContext.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) return NetUtils.isNetworkAvailableApiBelow21(connectivityManager);
        try {
            Network[] networks = connectivityManager.getAllNetworks();
            NetworkInfo networkInfo = null;
            if (networks == null) return false;
            for (Network mNetwork : networks) {
                try {
                    networkInfo = connectivityManager.getNetworkInfo(mNetwork);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (networkInfo == null || !NetworkInfo.State.CONNECTED.equals((Object)networkInfo.getState())) continue;
                return true;
            }
            return false;
        }
        catch (NoSuchMethodError e) {
            return NetUtils.isNetworkAvailableApiBelow21(connectivityManager);
        }
    }

    private static boolean isNetworkAvailableApiBelow21(ConnectivityManager connectivityManager) {
        NetworkInfo[] info = null;
        try {
            info = connectivityManager.getAllNetworkInfo();
        }
        catch (Exception ex) {
            return false;
        }
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    String ip = inetAddress.getHostAddress();
                    String[] splits = ip.split("\\.");
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    try {
                        Integer.parseInt(splits[0]);
                        return ip;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static boolean isIPHost(String host) {
        String regex = "(?:(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))";
        Pattern mPattern = null;
        mPattern = Pattern.compile(regex);
        Matcher matcher = mPattern.matcher(host);
        return matcher.matches();
    }
}

