/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil;

import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    private static final int STREAM_BUFFER_LENGTH = 10240;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getMD5(String source) {
        if (TextUtils.isEmpty((CharSequence)source)) {
            return "";
        }
        return MD5Utils.encodeHexString(MD5Utils.getMD5(source.getBytes()));
    }

    public static byte[] getMD5(byte[] data) {
        byte[] hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data);
            hash = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(File newFile) {
        FileInputStream data = null;
        try {
            data = new FileInputStream(newFile);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[10240];
            int read = data.read(buffer, 0, 10240);
            while (read > -1) {
                digest.update(buffer, 0, read);
                read = data.read(buffer, 0, 10240);
            }
            String string = MD5Utils.encodeHexString(digest.digest());
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (null != data) {
                try {
                    data.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String encodeHexString(byte[] data) {
        return new String(MD5Utils.encodeHex(data));
    }

    public static char[] encodeHex(byte[] data) {
        return MD5Utils.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return MD5Utils.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }
}

