/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class IOUtils {
    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeAllQuietly(closeable);
    }

    public static void closeAllQuietly(Closeable ... closeable) {
        if (closeable == null) {
            return;
        }
        for (Closeable c : closeable) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(URL url) throws Exception {
        URLConnection conn = url.openConnection();
        try {
            int len;
            InputStream inputStream = conn.getInputStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
            inputStream.close();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public static String toString(InputStream inputStream) throws Exception {
        int len;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = inputStream.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
        inputStream.close();
        return new String(output.toByteArray());
    }
}

