/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil;

import android.text.TextUtils;
import com.mm.mdlog.MDLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;

public class FileSizeUtil {
    private static final String TAG = "FileSizeUtil";
    public static final int SIZE_TYPE_B = 1;
    public static final int SIZE_TYPE_KB = 2;
    public static final int SIZE_TYPE_MB = 3;
    public static final int SIZE_TYPE_GB = 4;
    private static final double SIZE_KB = 1024.0;
    private static final double SIZE_MB = 1048576.0;
    private static final double SIZE_GB = 1.073741824E9;
    private static volatile FileSizeUtil sFileSizeUtil;
    private String pattern = "#.00";

    private FileSizeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileSizeUtil getInstance() {
        if (sFileSizeUtil != null) return sFileSizeUtil;
        Class<FileSizeUtil> clazz = FileSizeUtil.class;
        synchronized (FileSizeUtil.class) {
            if (sFileSizeUtil != null) return sFileSizeUtil;
            sFileSizeUtil = new FileSizeUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFileSizeUtil;
        }
    }

    public double getFileOrFileDirectorySize(String filePath, int sizeType) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? this.getFileDirectorySize(file) : this.getFileSize(file);
        }
        catch (Exception e) {
            MDLog.e((String)TAG, (String)"\u83b7\u53d6\u5931\u8d25!");
        }
        return this.FormatFileSize(blockSize, sizeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFileSize(File file) {
        long size = 0L;
        FileInputStream fileInputStream = null;
        if (file.exists()) {
            try {
                fileInputStream = new FileInputStream(file);
                size = fileInputStream.available();
            }
            catch (Exception exception) {
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return size;
    }

    private long getFileDirectorySize(File fileDirectory) throws Exception {
        File[] files;
        long size = 0L;
        for (File file : files = fileDirectory.listFiles()) {
            if (file.isDirectory()) {
                size += this.getFileDirectorySize(file);
                continue;
            }
            size += this.getFileSize(file);
        }
        return size;
    }

    private double FormatFileSize(double fileSize, int sizeType) {
        DecimalFormat df = new DecimalFormat(this.pattern);
        double fileSizeLong = 0.0;
        switch (sizeType) {
            case 1: {
                fileSizeLong = this.parseDouble(df.format(fileSize));
                break;
            }
            case 2: {
                fileSizeLong = this.parseDouble(df.format(fileSize / 1024.0));
                break;
            }
            case 3: {
                fileSizeLong = this.parseDouble(df.format(fileSize / 1048576.0));
                break;
            }
            case 4: {
                fileSizeLong = this.parseDouble(df.format(fileSize / 1.073741824E9));
                break;
            }
        }
        return fileSizeLong;
    }

    private double parseDouble(String parseStr) {
        if (!TextUtils.isEmpty((CharSequence)parseStr)) {
            try {
                return Double.valueOf(parseStr);
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return 0.0;
    }
}

