/*
 * Decompiled with CFR 0.152.
 */
package com.cosmos.mdlog;

import com.cosmos.mdlog.MDLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class XLogImpl
implements MDLog.LogImp {
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_EVENT = 3;
    public static final int LEVEL_WARNING = 4;
    public static final int LEVEL_ERROR = 5;
    public static final int LEVEL_FATAL = 6;
    public static final int LEVEL_NONE = 7;
    public static final int AppednerModeAsync = 0;
    public static final int AppednerModeSync = 1;
    private static List<String> whiteListTags;
    private static Map<Integer, List<String>> consoleTags;
    private static boolean isConsoleLogOpen;
    private static int level;

    public static void open(boolean isLoadLib, int mode, String cacheDir, String logDir, String nameprefix) {
        if (isLoadLib) {
            System.loadLibrary("mdlog");
        }
        XLogImpl.appenderOpen(7, mode, cacheDir, logDir, nameprefix);
    }

    private static String decryptTag(String tag) {
        return tag;
    }

    @Override
    public void logV(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        XLogImpl.logWrite2(0, XLogImpl.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logD(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        XLogImpl.logWrite2(1, XLogImpl.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logI(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        XLogImpl.logWrite2(2, XLogImpl.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logW(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        XLogImpl.logWrite2(4, XLogImpl.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logE(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        XLogImpl.logWrite2(5, XLogImpl.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logF(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        XLogImpl.logWrite2(6, XLogImpl.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logEvent(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        XLogImpl.logWrite2(3, XLogImpl.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void setLevel(int level) {
        XLogImpl.level = level;
        XLogImpl.setLogLevel(level);
    }

    @Override
    public int getLevel() {
        try {
            int level = this.getLogLevel();
            return level;
        }
        catch (Throwable throwable) {
            return level;
        }
    }

    @Override
    public void setLogcatOpen(boolean isOpen) {
        isConsoleLogOpen = isOpen;
        XLogImpl.setConsoleLogOpen(isOpen);
    }

    @Override
    public boolean isLogcatOpen() {
        return isConsoleLogOpen;
    }

    public static native void logWrite(XLoggerInfo var0, String var1);

    public static native void logWrite2(int var0, String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

    public native int getLogLevel();

    protected static native void setLogLevel(int var0);

    public static native void setAppenderMode(int var0);

    public static native void setConsoleLogOpen(boolean var0);

    public static native void setErrLogOpen(boolean var0);

    private static native void appenderOpen(int var0, int var1, String var2, String var3, String var4);

    public static native void appenderSetMaxFileSize(long var0);

    @Override
    public native void appenderClose();

    @Override
    public native void appenderFlush(boolean var1);

    private static native void addTag(String var0);

    private static native void clearAllTags();

    @Override
    public void registerWhiteList(List<String> tags) {
        if (whiteListTags == null) {
            whiteListTags = new CopyOnWriteArrayList<String>();
        }
        if (whiteListTags.size() > 0) {
            whiteListTags.clear();
            XLogImpl.clearAllTags();
        }
        for (String tag : tags) {
            XLogImpl.addTag(tag);
        }
        whiteListTags.addAll(tags);
    }

    @Override
    public void clearAllWhiteList() {
        if (whiteListTags != null) {
            whiteListTags.clear();
            whiteListTags = null;
        }
        XLogImpl.clearAllTags();
    }

    @Override
    public List<String> getWhiteListTags() {
        return whiteListTags;
    }

    @Deprecated
    public static void setShouldConsoleTags(List<String> tags, int level) {
        List<String> levelTags;
        if (level >= 4) {
            return;
        }
        if (consoleTags == null) {
            consoleTags = new ConcurrentHashMap<Integer, List<String>>();
        }
        if ((levelTags = consoleTags.get(level)) == null) {
            levelTags = new ArrayList<String>();
        }
        levelTags.addAll(tags);
        consoleTags.put(level, levelTags);
    }

    @Deprecated
    public static boolean mdConsolHook(String tag, int level) {
        List<String> levelTags;
        if (consoleTags != null && consoleTags.size() > 0 && (levelTags = consoleTags.get(level)) != null && levelTags.size() > 0) {
            return levelTags.contains(tag);
        }
        return true;
    }

    static {
        isConsoleLogOpen = false;
        level = 7;
    }

    static class XLoggerInfo {
        public int level;
        public String tag;
        public String filename;
        public String funcname;
        public int line;
        public long pid;
        public long tid;
        public long maintid;

        XLoggerInfo() {
        }
    }
}

