/*
 * Decompiled with CFR 0.152.
 */
package com.cosmos.mdlog;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import android.widget.Toast;
import com.cosmos.mdlog.IMDLogHook;
import com.cosmos.mdlog.XLogImpl;
import java.util.List;

public class MDLog {
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_EVENT = 3;
    public static final int LEVEL_WARNING = 4;
    public static final int LEVEL_ERROR = 5;
    public static final int LEVEL_FATAL = 6;
    public static final int LEVEL_NONE = 7;
    public static final int STACK_OFFSET = 4;
    private static int level = 7;
    private static boolean isOpenStackInfo = false;
    private static Class<?> logWrapperClass;
    public static Context toastSupportContext;
    private static boolean DEBUG_MODE;
    private static IMDLogHook mdLogHook;
    private static LogImp debugLog;
    private static LogImp logImp;
    private static final String SYS_INFO;

    public static IMDLogHook getMdLogHook() {
        return mdLogHook;
    }

    public static void setMdLogHook(IMDLogHook mdLogHook) {
        MDLog.mdLogHook = mdLogHook;
    }

    public static void setLogImp(LogImp imp) {
        logImp = imp;
    }

    public static LogImp getImpl() {
        return logImp;
    }

    public static void appenderClose() {
        if (logImp != null) {
            logImp.appenderClose();
        }
    }

    public static void appenderFlush(boolean isSync) {
        if (logImp != null) {
            logImp.appenderFlush(isSync);
        }
    }

    public static int getLogLevel() {
        if (logImp != null) {
            return logImp.getLevel();
        }
        return 7;
    }

    public static void setOpenStackInfo(boolean isOpen) {
        isOpenStackInfo = isOpen;
    }

    public static boolean isOpenStackInfo() {
        return isOpenStackInfo;
    }

    public static void setLogWrapperClass(Class<?> clazz) {
        logWrapperClass = clazz;
    }

    public static void getLogWrapperClass() {
        MDLog.getLogWrapperClass();
    }

    public static void setLevel(int level) {
        MDLog.level = level;
        if (logImp != null) {
            logImp.setLevel(level);
        }
    }

    public static void setDebugMode() {
        DEBUG_MODE = true;
    }

    public static void setConsoleLogOpen(boolean isOpen) {
        if (logImp != null) {
            logImp.setLogcatOpen(isOpen);
        }
    }

    public static void openFileWrite(String cacheDir, String logDir) {
        XLogImpl.open(true, 0, cacheDir, logDir, "mdlog_");
        XLogImpl.appenderSetMaxFileSize(307200L);
        MDLog.setLogImp(new XLogImpl());
    }

    public static boolean isConsoleLogOpen() {
        if (logImp != null) {
            return logImp.isLogcatOpen();
        }
        return false;
    }

    public static void registerWhiteList(List<String> tags) {
        if (logImp != null) {
            logImp.registerWhiteList(tags);
        }
    }

    public static void clearAllWhiteList() {
        if (logImp != null) {
            logImp.clearAllWhiteList();
        }
    }

    public static boolean isWhiteListIntercept(String tag) {
        List<String> whiteListTags;
        if (DEBUG_MODE) {
            return false;
        }
        return logImp != null && (whiteListTags = logImp.getWhiteListTags()) != null && whiteListTags.size() > 0 && !whiteListTags.contains(tag);
    }

    public static List<String> getWhiteListTags() {
        if (logImp != null) {
            return logImp.getWhiteListTags();
        }
        return null;
    }

    public static void printErrStackTrace(String tag, Throwable tr) {
        MDLog.printErrStackTrace(tag, tr, "", new Object[0]);
    }

    public static void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
        if (level <= 5 && logImp != null && !MDLog.isWhiteListIntercept(tag)) {
            StackTraceElement elements;
            String log;
            if (format == null) {
                format = "";
            }
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            String fileName = "";
            String methodName = "";
            int lineNum = 0;
            if (isOpenStackInfo && (elements = MDLog.getInvokeStack()) != null) {
                fileName = elements.getFileName();
                methodName = elements.getMethodName();
                lineNum = elements.getLineNumber();
            }
            log = log + "  " + Log.getStackTraceString((Throwable)tr);
            if (mdLogHook != null && mdLogHook.onLogPrint(5, tag, log)) {
                return;
            }
            logImp.logE(tag, fileName, methodName, lineNum, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void f(String tag, String msg) {
        MDLog.f(tag, msg, null);
    }

    public static void e(String tag, String msg) {
        MDLog.e(tag, msg, null);
    }

    public static void w(String tag, String msg) {
        MDLog.w(tag, msg, null);
    }

    public static void i(String tag, String msg) {
        MDLog.i(tag, msg, null);
    }

    public static void d(String tag, String msg) {
        MDLog.d(tag, msg, null);
    }

    public static void v(String tag, String msg) {
        MDLog.v(tag, msg, null);
    }

    public static void f(String tag, String format, Object ... obj) {
        if (level <= 6 && logImp != null && !MDLog.isWhiteListIntercept(tag)) {
            StackTraceElement elements;
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (mdLogHook != null && mdLogHook.onLogPrint(6, tag, log)) {
                return;
            }
            String fileName = "";
            String methodName = "";
            int lineNum = 0;
            if (isOpenStackInfo && (elements = MDLog.getInvokeStack()) != null) {
                fileName = elements.getFileName();
                methodName = elements.getMethodName();
                lineNum = elements.getLineNumber();
            }
            logImp.logF(tag, fileName, methodName, lineNum, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void e(String tag, String format, Object ... obj) {
        if (level <= 5 && logImp != null && !MDLog.isWhiteListIntercept(tag)) {
            StackTraceElement elements;
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            if (mdLogHook != null && mdLogHook.onLogPrint(5, tag, log)) {
                return;
            }
            String fileName = "";
            String methodName = "";
            int lineNum = 0;
            if (isOpenStackInfo && (elements = MDLog.getInvokeStack()) != null) {
                fileName = elements.getFileName();
                methodName = elements.getMethodName();
                lineNum = elements.getLineNumber();
            }
            logImp.logE(tag, fileName, methodName, lineNum, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void w(String tag, String format, Object ... obj) {
        if (level <= 4 && logImp != null && !MDLog.isWhiteListIntercept(tag)) {
            StackTraceElement elements;
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            if (mdLogHook != null && mdLogHook.onLogPrint(4, tag, log)) {
                return;
            }
            String fileName = "";
            String methodName = "";
            int lineNum = 0;
            if (isOpenStackInfo && (elements = MDLog.getInvokeStack()) != null) {
                fileName = elements.getFileName();
                methodName = elements.getMethodName();
                lineNum = elements.getLineNumber();
            }
            logImp.logW(tag, fileName, methodName, lineNum, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void i(String tag, String format, Object ... obj) {
        if (level <= 2 && logImp != null && !MDLog.isWhiteListIntercept(tag)) {
            StackTraceElement elements;
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            if (mdLogHook != null && mdLogHook.onLogPrint(2, tag, log)) {
                return;
            }
            String fileName = "";
            String methodName = "";
            int lineNum = 0;
            if (isOpenStackInfo && (elements = MDLog.getInvokeStack()) != null) {
                fileName = elements.getFileName();
                methodName = elements.getMethodName();
                lineNum = elements.getLineNumber();
            }
            logImp.logI(tag, fileName, methodName, lineNum, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void d(String tag, String format, Object ... obj) {
        if (level <= 1 && logImp != null && !MDLog.isWhiteListIntercept(tag)) {
            StackTraceElement elements;
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            if (mdLogHook != null && mdLogHook.onLogPrint(1, tag, log)) {
                return;
            }
            String fileName = "";
            String methodName = "";
            int lineNum = 0;
            if (isOpenStackInfo && (elements = MDLog.getInvokeStack()) != null) {
                fileName = elements.getFileName();
                methodName = elements.getMethodName();
                lineNum = elements.getLineNumber();
            }
            logImp.logD(tag, fileName, methodName, lineNum, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void v(String tag, String format, Object ... obj) {
        if (level <= 0 && logImp != null && !MDLog.isWhiteListIntercept(tag)) {
            StackTraceElement elements;
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            if (mdLogHook != null && mdLogHook.onLogPrint(0, tag, log)) {
                return;
            }
            String fileName = "";
            String methodName = "";
            int lineNum = 0;
            if (isOpenStackInfo && (elements = MDLog.getInvokeStack()) != null) {
                fileName = elements.getFileName();
                methodName = elements.getMethodName();
                lineNum = elements.getLineNumber();
            }
            logImp.logV(tag, fileName, methodName, lineNum, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void event(String tag, String format, Object ... obj) {
        if (level <= 3 && logImp != null && !MDLog.isWhiteListIntercept(tag)) {
            StackTraceElement elements;
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            if (mdLogHook != null && mdLogHook.onLogPrint(3, tag, String.format(format, obj))) {
                return;
            }
            String fileName = "";
            String methodName = "";
            int lineNum = 0;
            if (isOpenStackInfo && (elements = MDLog.getInvokeStack()) != null) {
                fileName = elements.getFileName();
                methodName = elements.getMethodName();
                lineNum = elements.getLineNumber();
            }
            logImp.logEvent(tag, fileName, methodName, lineNum, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    private static StackTraceElement getInvokeStack() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (logWrapperClass != null) {
            boolean invokeInWrapper = false;
            String invokeClassName = elements[4].getClassName();
            String upperInvokeClassName = null;
            if (5 < elements.length - 1) {
                upperInvokeClassName = elements[5].getClassName();
            }
            if (!logWrapperClass.getName().equals(invokeClassName) && !MDLog.class.getName().equals(invokeClassName)) {
                return elements[4];
            }
            if (!logWrapperClass.getName().equals(upperInvokeClassName) && !MDLog.class.getName().equals(upperInvokeClassName)) {
                return elements[5];
            }
            int length = elements.length;
            for (int i = 4; i < length; ++i) {
                if (logWrapperClass.getName().equals(elements[i].getClassName())) {
                    invokeInWrapper = true;
                    continue;
                }
                if (!invokeInWrapper) continue;
                return elements[i];
            }
        } else {
            String invokeClassName = elements[4].getClassName();
            if (MDLog.class.getName().equals(invokeClassName)) {
                return elements[5];
            }
            return elements[4];
        }
        return null;
    }

    public static String getSysInfo() {
        return SYS_INFO;
    }

    static {
        toastSupportContext = null;
        DEBUG_MODE = false;
        mdLogHook = null;
        logImp = debugLog = new LogImp(){
            private Handler handler = new Handler(Looper.getMainLooper());

            @Override
            public void logV(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 0) {
                    Log.v((String)tag, (String)log);
                }
            }

            @Override
            public void logI(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 2) {
                    Log.i((String)tag, (String)log);
                }
            }

            @Override
            public void logD(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 1) {
                    Log.d((String)tag, (String)log);
                }
            }

            @Override
            public void logW(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 4) {
                    Log.w((String)tag, (String)log);
                }
            }

            @Override
            public void logE(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 5) {
                    Log.e((String)tag, (String)log);
                }
            }

            @Override
            public void logF(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, final String log) {
                if (level > 6) {
                    return;
                }
                Log.e((String)tag, (String)log);
                if (toastSupportContext != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)toastSupportContext, (CharSequence)log, (int)1).show();
                        }
                    });
                }
            }

            @Override
            public void logEvent(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 3) {
                    Log.i((String)tag, (String)log);
                }
            }

            @Override
            public void setLevel(int level) {
            }

            @Override
            public int getLevel() {
                return level;
            }

            @Override
            public void appenderClose() {
            }

            @Override
            public void appenderFlush(boolean isSync) {
            }

            @Override
            public void setLogcatOpen(boolean isOpen) {
            }

            @Override
            public boolean isLogcatOpen() {
                return false;
            }

            @Override
            public void registerWhiteList(List<String> tags) {
            }

            @Override
            public void clearAllWhiteList() {
            }

            @Override
            public List<String> getWhiteListTags() {
                return null;
            }
        };
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("VERSION.RELEASE:[" + Build.VERSION.RELEASE);
            sb.append("] VERSION.CODENAME:[" + Build.VERSION.CODENAME);
            sb.append("] VERSION.INCREMENTAL:[" + Build.VERSION.INCREMENTAL);
            sb.append("] BOARD:[" + Build.BOARD);
            sb.append("] DEVICE:[" + Build.DEVICE);
            sb.append("] DISPLAY:[" + Build.DISPLAY);
            sb.append("] FINGERPRINT:[" + Build.FINGERPRINT);
            sb.append("] HOST:[" + Build.HOST);
            sb.append("] MANUFACTURER:[" + Build.MANUFACTURER);
            sb.append("] MODEL:[" + Build.MODEL);
            sb.append("] PRODUCT:[" + Build.PRODUCT);
            sb.append("] TAGS:[" + Build.TAGS);
            sb.append("] TYPE:[" + Build.TYPE);
            sb.append("] USER:[" + Build.USER + "]");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        SYS_INFO = sb.toString();
    }

    public static interface LogImp {
        public void logV(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logI(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logD(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logW(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logE(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logF(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logEvent(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void setLevel(int var1);

        public int getLevel();

        public void appenderClose();

        public void appenderFlush(boolean var1);

        public void setLogcatOpen(boolean var1);

        public boolean isLogcatOpen();

        public void registerWhiteList(List<String> var1);

        public void clearAllWhiteList();

        public List<String> getWhiteListTags();
    }
}

